/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.test4j.tools.commons.StrBuilder;
import org.test4j.tools.commons.StrMatcher;

public class StrSubstitutor {
    public static final char DEFAULT_ESCAPE = '$';
    public static final StrMatcher DEFAULT_PREFIX = StrMatcher.stringMatcher("${");
    public static final StrMatcher DEFAULT_SUFFIX = StrMatcher.stringMatcher("}");
    private char escapeChar;
    private StrMatcher prefixMatcher;
    private StrMatcher suffixMatcher;
    private final Map<String, String> variableResolver;

    public static String replace(Object source, Map valueMap) {
        return new StrSubstitutor(valueMap).replace(source);
    }

    public StrSubstitutor(Map<String, String> valueMap) {
        this(valueMap, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public StrSubstitutor(Map<String, String> variableResolver, StrMatcher prefixMatcher, StrMatcher suffixMatcher, char escape) {
        this.variableResolver = variableResolver;
        this.setVariablePrefixMatcher(prefixMatcher);
        this.setVariableSuffixMatcher(suffixMatcher);
        this.setEscapeChar(escape);
    }

    public String replace(Object source) {
        if (source == null) {
            return null;
        }
        StrBuilder buf = new StrBuilder().append(source);
        this.substitute(buf, buf.length());
        return buf.toString();
    }

    protected boolean substitute(StrBuilder buf, int length) {
        return this.substitute(buf, 0, length, null) > 0;
    }

    private int substitute(StrBuilder buf, int offset, int length, List priorVariables) {
        boolean top = priorVariables == null;
        boolean altered = false;
        int lengthChange = 0;
        char[] chars = buf.buffer;
        int bufEnd = offset + length;
        int pos = offset;
        block0: while (pos < bufEnd) {
            int startMatchLen = this.prefixMatcher.isMatch(chars, pos, bufEnd);
            if (startMatchLen == 0) {
                ++pos;
                continue;
            }
            if (pos > offset && chars[pos - 1] == this.escapeChar) {
                buf.deleteCharAt(pos - 1);
                chars = buf.buffer;
                --lengthChange;
                altered = true;
                --bufEnd;
                continue;
            }
            int startPos = pos;
            pos += startMatchLen;
            while (pos < bufEnd) {
                int endMatchLen = this.suffixMatcher.isMatch(chars, pos, bufEnd);
                if (endMatchLen == 0) {
                    ++pos;
                    continue;
                }
                String varName = new String(chars, startPos + startMatchLen, pos - startPos - startMatchLen);
                int endPos = pos += endMatchLen;
                if (priorVariables == null) {
                    priorVariables = new ArrayList<String>();
                    priorVariables.add(new String(chars, offset, length));
                }
                this.checkCyclicSubstitution(varName, priorVariables);
                priorVariables.add(varName);
                String varValue = this.resolveVariable(varName);
                if (varValue != null) {
                    int varLen = varValue.length();
                    buf.replace(startPos, endPos, varValue);
                    altered = true;
                    int change = this.substitute(buf, startPos, varLen, priorVariables);
                    pos += (change += varLen - (endPos - startPos));
                    bufEnd += change;
                    lengthChange += change;
                    chars = buf.buffer;
                }
                priorVariables.remove(priorVariables.size() - 1);
                continue block0;
            }
        }
        if (top) {
            return altered ? 1 : 0;
        }
        return lengthChange;
    }

    private void checkCyclicSubstitution(String varName, List priorVariables) {
        if (!priorVariables.contains(varName)) {
            return;
        }
        StrBuilder buf = new StrBuilder(256);
        buf.append("Infinite loop in property interpolation of ");
        buf.append(priorVariables.remove(0));
        buf.append(": ");
        buf.appendWithSeparators(priorVariables, "->");
        throw new IllegalStateException(buf.toString());
    }

    protected String resolveVariable(String variableName) {
        Map<String, String> resolver = this.getVariableResolver();
        if (resolver == null) {
            return null;
        }
        return resolver.get(variableName);
    }

    public void setEscapeChar(char escapeCharacter) {
        this.escapeChar = escapeCharacter;
    }

    public StrSubstitutor setVariablePrefixMatcher(StrMatcher prefixMatcher) {
        if (prefixMatcher == null) {
            throw new IllegalArgumentException("Variable prefix matcher must not be null!");
        }
        this.prefixMatcher = prefixMatcher;
        return this;
    }

    public StrSubstitutor setVariableSuffixMatcher(StrMatcher suffixMatcher) {
        if (suffixMatcher == null) {
            throw new IllegalArgumentException("Variable suffix matcher must not be null!");
        }
        this.suffixMatcher = suffixMatcher;
        return this;
    }

    public Map<String, String> getVariableResolver() {
        return this.variableResolver;
    }
}

