/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.matcher.property;

import java.util.Objects;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.test4j.hamcrest.matcher.string.StringMode;
import org.test4j.tools.IKit;
import org.test4j.tools.commons.ArrayHelper;

public class PropertyEqualStringMatcher
extends BaseMatcher {
    private final String expected;
    private final String property;
    private final StringMode[] modes;
    private final StringBuilder buff = new StringBuilder();

    public PropertyEqualStringMatcher(String expected, String properties, StringMode[] modes) {
        this.expected = expected;
        this.property = properties;
        if (this.property == null) {
            throw new RuntimeException("the properties can't be empty.");
        }
        this.modes = modes;
    }

    public PropertyEqualStringMatcher(String expected, String property) {
        this(expected, property, null);
    }

    public boolean matches(Object actual) {
        String actualString;
        if (actual == null) {
            this.buff.append("properties equals matcher, the actual value can't be null.");
            return false;
        }
        if (ArrayHelper.isCollOrArray(actual)) {
            this.buff.append("PropertyEqualStringMatcher can only accept PoJo Object or Map, but actual is Array/List.");
            return false;
        }
        Object propValue = IKit.ognl.value(actual, this.property, true);
        String expectedString = StringMode.getStringByMode(this.expected, this.modes);
        boolean match = Objects.equals(expectedString, actualString = StringMode.getStringByMode(propValue == null ? null : String.valueOf(propValue), this.modes));
        if (!match) {
            this.description(expectedString, actualString);
        }
        return match;
    }

    private void description(String expected, String actual) {
        this.buff.append("expected property eq by modes");
        this.buff.append(" ").append(expected);
        this.buff.append("\n, but actual string is:");
        this.buff.append(actual).append(".\n");
    }

    public void describeTo(Description description) {
        description.appendText(this.buff.toString());
    }
}

