/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.iassert.interal;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.test4j.hamcrest.matcher.LinkMatcher;
import org.test4j.tools.IKit;

public interface IAssert<T, E extends IAssert>
extends Matcher<T> {
    public T wanted();

    public <F> F wanted(Class<F> var1);

    default public E print() {
        System.out.println(IKit.json.toJSON(this.getAssertObject().getValue(), true));
        return (E)this;
    }

    public E assertThat(Matcher var1);

    public E assertThat(String var1, Matcher var2);

    public AssertObject getAssertObject();

    public static class AssertObject {
        protected Class targetClass = null;
        protected Object value;
        protected AssertType type;
        protected Class expectedClass;
        protected LinkMatcher<?> link;

        public AssertObject(AssertType type, Object value, Class expectedClass) {
            this.expectedClass = expectedClass;
            this.value = value;
            this.type = type;
        }

        public static void assertCanComparable(Object o) {
            if (o != null && !(o instanceof Comparable)) {
                throw new AssertionError((Object)("the object[" + o + "] isn't a comparable object."));
            }
        }

        public Object isNumberAndConvert(Object expected) {
            if (expected == null) {
                return null;
            }
            if (this.valueIsInteger()) {
                return Integer.parseInt(expected.toString());
            }
            if (this.valueIsShort()) {
                return Short.parseShort(expected.toString());
            }
            if (this.valueIsLong()) {
                return Long.parseLong(expected.toString());
            }
            if (this.valueIsFloat()) {
                return Float.valueOf(Float.parseFloat(expected.toString()));
            }
            if (this.valueIsDouble()) {
                return Double.parseDouble(expected.toString());
            }
            return expected;
        }

        public void assertTargetClassNotNull() {
            assert (this.targetClass != null) : "the value asserted must not be null.";
        }

        public boolean valueIsDouble() {
            return this.targetClass == Double.TYPE || this.targetClass == Double.class;
        }

        public boolean valueIsFloat() {
            return this.targetClass == Float.TYPE || this.targetClass == Float.class;
        }

        public boolean valueIsLong() {
            return this.targetClass == Long.TYPE || this.targetClass == Long.class;
        }

        public boolean valueIsShort() {
            return this.targetClass == Short.TYPE || this.targetClass == Short.class;
        }

        public boolean valueIsInteger() {
            return this.targetClass == Integer.TYPE || this.targetClass == Integer.class;
        }

        public boolean valueIsArray() {
            return this.targetClass != null && this.targetClass.isArray();
        }

        public boolean valueIsList() {
            return this.targetClass != null && Collection.class.isAssignableFrom(this.targetClass);
        }

        public boolean assertTypeIs(AssertType assertType) {
            return assertType != null && assertType.equals((Object)this.type);
        }

        public String valueToString() {
            return String.valueOf(this.value);
        }

        public boolean isArrayOrList() {
            return this.valueIsList() || this.valueIsArray();
        }

        public Class getTargetClass() {
            return this.targetClass;
        }

        public Object getValue() {
            return this.value;
        }

        public AssertType getType() {
            return this.type;
        }

        public Class getExpectedClass() {
            return this.expectedClass;
        }

        public LinkMatcher<?> getLink() {
            return this.link;
        }

        public AssertObject setTargetClass(Class targetClass) {
            this.targetClass = targetClass;
            return this;
        }

        public AssertObject setValue(Object value) {
            this.value = value;
            return this;
        }

        public AssertObject setType(AssertType type) {
            this.type = type;
            return this;
        }

        public AssertObject setExpectedClass(Class expectedClass) {
            this.expectedClass = expectedClass;
            return this;
        }

        public AssertObject setLink(LinkMatcher<?> link) {
            this.link = link;
            return this;
        }
    }

    public static enum AssertType {
        AssertStyle,
        MatcherStyle;

    }
}

