/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.iassert.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.hamcrest.Matcher;
import org.test4j.hamcrest.iassert.interal.Assert;
import org.test4j.hamcrest.iassert.interal.IAssert;
import org.test4j.hamcrest.iassert.intf.IDateAssert;
import org.test4j.hamcrest.matcher.LinkMatcher;
import org.test4j.hamcrest.matcher.calendar.DateFormatMatcher;
import org.test4j.hamcrest.matcher.calendar.DateParterMatcher;
import org.test4j.tools.commons.DateHelper;

public class DateAssert<T>
extends Assert<T, IDateAssert<T>>
implements IDateAssert<T> {
    public DateAssert(Class<T> clazz) {
        super(clazz, (Class<? extends IAssert>)IDateAssert.class);
        this.getAssertObject().setLink(new LinkMatcher());
    }

    public DateAssert(T value, Class<T> clazz) {
        super(value, clazz, IDateAssert.class);
    }

    @Override
    public IDateAssert<T> isYear(int year) {
        return this.assertThat(year, DateParterMatcher.DateFieldType.YEAR);
    }

    @Override
    public IDateAssert<T> isYear(String year) {
        return this.assertThat(year, DateParterMatcher.DateFieldType.YEAR);
    }

    @Override
    public IDateAssert<T> isDay(int day) {
        return this.assertThat(day, DateParterMatcher.DateFieldType.DATE);
    }

    @Override
    public IDateAssert<T> isDay(String day) {
        return this.assertThat(day, DateParterMatcher.DateFieldType.DATE);
    }

    @Override
    public IDateAssert<T> isHour(int hour) {
        return this.assertThat(hour, DateParterMatcher.DateFieldType.HOUR);
    }

    @Override
    public IDateAssert<T> isHour(String hour) {
        return this.assertThat(hour, DateParterMatcher.DateFieldType.HOUR);
    }

    @Override
    public IDateAssert<T> isMinute(int minute) {
        return this.assertThat(minute, DateParterMatcher.DateFieldType.MINUTE);
    }

    @Override
    public IDateAssert<T> isMinute(String minute) {
        return this.assertThat(minute, DateParterMatcher.DateFieldType.MINUTE);
    }

    @Override
    public IDateAssert<T> isMonth(int month) {
        return this.assertThat(month, DateParterMatcher.DateFieldType.MONTH);
    }

    @Override
    public IDateAssert<T> isMonth(String month) {
        return this.assertThat(month, DateParterMatcher.DateFieldType.MONTH);
    }

    @Override
    public IDateAssert<T> isSecond(int second) {
        return this.assertThat(second, DateParterMatcher.DateFieldType.SECOND);
    }

    @Override
    public IDateAssert<T> isSecond(String second) {
        return this.assertThat(second, DateParterMatcher.DateFieldType.SECOND);
    }

    private IDateAssert<T> assertThat(int value, DateParterMatcher.DateFieldType type) {
        DateParterMatcher matcher = new DateParterMatcher(value, type);
        return (IDateAssert)this.assertThat((Matcher)matcher);
    }

    private IDateAssert<T> assertThat(String value, DateParterMatcher.DateFieldType type) {
        DateParterMatcher matcher = new DateParterMatcher(Integer.parseInt(value), type);
        return (IDateAssert)this.assertThat((Matcher)matcher);
    }

    @Override
    public IDateAssert<T> eqByFormat(String expected, String format) {
        DateFormatMatcher matcher = new DateFormatMatcher(format, expected);
        return (IDateAssert)this.assertThat((Matcher)matcher);
    }

    @Override
    public IDateAssert<T> eqByFormat(String expected) {
        SimpleDateFormat df = DateHelper.getDateFormat(expected);
        DateFormatMatcher matcher = new DateFormatMatcher(df, expected);
        return (IDateAssert)this.assertThat((Matcher)matcher);
    }

    @Override
    public IDateAssert<T> isEqualTo(long time) {
        Date date = new Date(time);
        return (IDateAssert)this.isEqualTo(date);
    }

    @Override
    public IDateAssert<T> isEqualTo(Calendar calendar) {
        Date date = calendar.getTime();
        return (IDateAssert)this.isEqualTo(date);
    }
}

