/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.diff;

import java.util.List;
import java.util.Map;
import org.test4j.hamcrest.diff.DiffByList;
import org.test4j.hamcrest.diff.DiffMap;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.tools.commons.ArrayHelper;
import org.test4j.tools.commons.ListHelper;
import org.test4j.tools.commons.StringHelper;

public abstract class BaseDiff<T> {
    protected final boolean ignoreNull;
    protected final boolean asString;
    protected final boolean ignoreOrder;
    protected boolean ignoreDefault;
    protected boolean ignoreDateType;
    protected final DiffMap diffMap;

    public BaseDiff(EqMode ... modes) {
        List list = ListHelper.toList(modes);
        this.ignoreNull = list.contains((Object)EqMode.IGNORE_DEFAULTS);
        this.asString = list.contains((Object)EqMode.EQ_STRING);
        this.ignoreOrder = list.contains((Object)EqMode.IGNORE_ORDER);
        this.ignoreDateType = list.contains((Object)EqMode.IGNORE_DATES);
        this.diffMap = new DiffMap();
    }

    public BaseDiff(boolean ignoreNull, boolean asString, boolean ignoreOrder) {
        this.ignoreNull = ignoreNull;
        this.asString = asString;
        this.ignoreOrder = ignoreOrder;
        this.diffMap = new DiffMap();
    }

    public BaseDiff(BaseDiff diff) {
        this.ignoreNull = diff.ignoreNull;
        this.asString = diff.asString;
        this.ignoreOrder = diff.ignoreOrder;
        this.ignoreDefault = diff.ignoreDefault;
        this.ignoreDateType = diff.ignoreDateType;
        this.diffMap = diff.diffMap;
    }

    public BaseDiff(DiffByList diff, DiffMap diffMap) {
        this.ignoreNull = diff.ignoreNull;
        this.asString = diff.asString;
        this.ignoreOrder = diff.ignoreOrder;
        this.ignoreDefault = diff.ignoreDefault;
        this.ignoreDateType = diff.ignoreDateType;
        this.diffMap = diffMap;
    }

    public abstract DiffMap compare(Object var1, Object var2, T var3);

    protected boolean validateNull(Object parentKey, Object actual, Object expect) {
        if (expect == null) {
            if (actual != null && !this.ignoreNull) {
                this.diffMap.add(parentKey, actual, null);
            } else {
                this.diffMap.addIgnore();
            }
            return true;
        }
        if (actual == null) {
            this.diffMap.add(parentKey, null, expect);
            return true;
        }
        return actual.equals(expect);
    }

    protected Object asObject(Object value, boolean asString) {
        if (value == null || value instanceof String) {
            return value;
        }
        if (value instanceof Map || ArrayHelper.isCollOrArray(value)) {
            return value;
        }
        if (value.getClass().isPrimitive()) {
            return String.valueOf(value);
        }
        if (asString) {
            return StringHelper.toJsonString(value);
        }
        return value;
    }

    public static String asString(Object value) {
        if (value == null) {
            return "<null>";
        }
        if (value.getClass().isPrimitive() || value instanceof String) {
            return "(" + value.getClass().getSimpleName() + ") " + value;
        }
        return "(" + value.getClass().getSimpleName() + ") " + StringHelper.toJsonString(value);
    }
}

