/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.jfinal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.SysConst;

public class Prop {
    private static Logger log = LoggerFactory.getLogger(Prop.class);
    private Properties properties = null;

    public Prop(String fileName) {
        this(fileName, "utf-8");
    }

    public Prop(String fileName, String encoding) {
        this(fileName, Charset.forName(encoding));
    }

    public Prop(String fileName, Charset charset) {
        InputStream inputStream = null;
        try {
            inputStream = this.getClassLoader().getResourceAsStream(fileName);
            if (inputStream == null) {
                throw new IllegalArgumentException("Properties file not found in classpath: " + fileName);
            }
            this.properties = new Properties();
            this.properties.load(new InputStreamReader(inputStream, charset));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : this.getClass().getClassLoader();
    }

    public Prop(File file) {
        this(file, "utf-8");
    }

    public Prop(File file, String encoding) {
        this(file, Charset.forName(encoding));
    }

    public Prop(File file, Charset charset) {
        if (file == null) {
            throw new IllegalArgumentException("File can not be null.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("File not found : " + file.getName());
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            this.properties = new Properties();
            this.properties.load(new InputStreamReader((InputStream)inputStream, charset));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public Prop append(Prop prop) {
        if (prop == null) {
            throw new IllegalArgumentException("prop can not be null");
        }
        this.properties.putAll((Map<?, ?>)prop.getProperties());
        return this;
    }

    public Prop append(String fileName, String encoding) {
        return this.append(new Prop(fileName, encoding));
    }

    public Prop append(String fileName, Charset charset) {
        return this.append(new Prop(fileName, charset));
    }

    public Prop append(String fileName) {
        return this.append(fileName, SysConst.DEFAULT_CHARSET);
    }

    public Prop appendIfExists(String fileName, String encoding) {
        try {
            return this.append(new Prop(fileName, encoding));
        }
        catch (Exception e) {
            return this;
        }
    }

    public Prop appendIfExists(String fileName) {
        return this.appendIfExists(fileName, "utf-8");
    }

    public Prop append(File file, String encoding) {
        return this.append(new Prop(file, encoding));
    }

    public Prop append(File file) {
        return this.append(file, "utf-8");
    }

    public Prop appendIfExists(File file, String encoding) {
        if (file.exists()) {
            this.append(new Prop(file, encoding));
        }
        return this;
    }

    public Prop appendIfExists(File file) {
        return this.appendIfExists(file, "utf-8");
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return Integer.parseInt(value.trim());
        }
        return defaultValue;
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return Long.parseLong(value.trim());
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            if ("true".equals(value = value.toLowerCase().trim())) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            throw new RuntimeException("The value can not parse to Boolean : " + value);
        }
        return defaultValue;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Properties getProperties() {
        return this.properties;
    }
}

