/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache.guavaredis;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.cache.AbsCache;
import org.tio.utils.cache.CacheChangeType;
import org.tio.utils.cache.CacheChangedVo;
import org.tio.utils.cache.guava.GuavaCache;
import org.tio.utils.cache.redis.RedisCache;
import org.tio.utils.cache.redis.RedisExpireUpdateTask;
import org.tio.utils.hutool.StrUtil;

public class GuavaRedisCache
extends AbsCache {
    public static final String CACHE_CHANGE_TOPIC = "TIO_CACHE_CHANGE_TOPIC_GUAVA";
    private static Logger log = LoggerFactory.getLogger(GuavaRedisCache.class);
    public static Map<String, GuavaRedisCache> map = new HashMap<String, GuavaRedisCache>();
    static RTopic topic;
    private static boolean inited;
    GuavaCache guavaCache;
    RedisCache redisCache;

    public static GuavaRedisCache getCache(String cacheName) {
        GuavaRedisCache guavaRedisCache = map.get(cacheName);
        if (guavaRedisCache == null) {
            log.warn("cacheName[{}]\u8fd8\u6ca1\u6ce8\u518c\uff0c\u8bf7\u521d\u59cb\u5316\u65f6\u8c03\u7528\uff1a{}.register(cacheName, timeToLiveSeconds, timeToIdleSeconds)", (Object)cacheName, (Object)GuavaRedisCache.class.getSimpleName());
        }
        return guavaRedisCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init(RedissonClient redisson) {
        if (inited) return;
        Class<GuavaRedisCache> clazz = GuavaRedisCache.class;
        synchronized (GuavaRedisCache.class) {
            if (inited) return;
            topic = redisson.getTopic(CACHE_CHANGE_TOPIC);
            topic.addListener(CacheChangedVo.class, (MessageListener)new MessageListener<CacheChangedVo>(){

                public void onMessage(CharSequence channel, CacheChangedVo cacheChangedVo) {
                    String clientid = cacheChangedVo.getClientId();
                    if (StrUtil.isBlank(clientid)) {
                        log.error("clientid is null");
                        return;
                    }
                    if (Objects.equals(CacheChangedVo.CLIENTID, clientid)) {
                        log.debug("\u81ea\u5df1\u53d1\u5e03\u7684\u6d88\u606f,{}", (Object)clientid);
                        return;
                    }
                    String cacheName = cacheChangedVo.getCacheName();
                    GuavaRedisCache guavaRedisCache = GuavaRedisCache.getCache(cacheName);
                    if (guavaRedisCache == null) {
                        log.info("\u4e0d\u80fd\u6839\u636ecacheName[{}]\u627e\u5230GuavaRedisCache\u5bf9\u8c61", (Object)cacheName);
                        return;
                    }
                    CacheChangeType type = cacheChangedVo.getType();
                    if (type == CacheChangeType.PUT || type == CacheChangeType.UPDATE || type == CacheChangeType.REMOVE) {
                        String key = cacheChangedVo.getKey();
                        guavaRedisCache.guavaCache.remove(key);
                    } else if (type == CacheChangeType.CLEAR) {
                        guavaRedisCache.guavaCache.clear();
                    }
                }
            });
            inited = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GuavaRedisCache register(RedissonClient redisson, String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        GuavaRedisCache.init(redisson);
        GuavaRedisCache guavaRedisCache = map.get(cacheName);
        if (guavaRedisCache != null) return guavaRedisCache;
        Class<GuavaRedisCache> clazz = GuavaRedisCache.class;
        synchronized (GuavaRedisCache.class) {
            guavaRedisCache = map.get(cacheName);
            if (guavaRedisCache != null) return guavaRedisCache;
            RedisCache redisCache = RedisCache.register(redisson, cacheName, timeToLiveSeconds, timeToIdleSeconds);
            Long timeToLiveSecondsForGuava = timeToLiveSeconds;
            Long timeToIdleSecondsForGuava = timeToIdleSeconds;
            if (timeToLiveSecondsForGuava != null) {
                timeToLiveSecondsForGuava = Math.min(timeToLiveSecondsForGuava, 600L);
            }
            if (timeToIdleSecondsForGuava != null) {
                timeToIdleSecondsForGuava = Math.min(timeToIdleSecondsForGuava, 600L);
            }
            GuavaCache guavaCache = GuavaCache.register(cacheName, timeToLiveSecondsForGuava, timeToIdleSecondsForGuava);
            guavaRedisCache = new GuavaRedisCache(cacheName, guavaCache, redisCache);
            guavaRedisCache.setTimeToIdleSeconds(timeToIdleSeconds);
            guavaRedisCache.setTimeToLiveSeconds(timeToLiveSeconds);
            map.put(cacheName, guavaRedisCache);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return guavaRedisCache;
        }
    }

    public GuavaRedisCache(String cacheName, GuavaCache guavaCache, RedisCache redisCache) {
        super(cacheName);
        this.guavaCache = guavaCache;
        this.redisCache = redisCache;
    }

    @Override
    public void clear() {
        this.guavaCache.clear();
        this.redisCache.clear();
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, CacheChangeType.CLEAR);
        topic.publish((Object)cacheChangedVo);
    }

    @Override
    public Serializable _get(String key) {
        if (StrUtil.isBlank(key)) {
            return null;
        }
        Serializable ret = this.guavaCache.get(key);
        if (ret == null) {
            ret = this.redisCache.get(key);
            if (ret != null) {
                this.guavaCache.put(key, ret);
            }
        } else {
            Long timeToIdleSeconds = this.redisCache.getTimeToIdleSeconds();
            if (timeToIdleSeconds != null) {
                RedisExpireUpdateTask.add(this.cacheName, key, timeToIdleSeconds);
            }
        }
        return ret;
    }

    @Override
    public Iterable<String> keys() {
        return this.redisCache.keys();
    }

    @Override
    public void put(String key, Serializable value) {
        this.guavaCache.put(key, value);
        this.redisCache.put(key, value);
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, key, CacheChangeType.PUT);
        topic.publish((Object)cacheChangedVo);
    }

    @Override
    public void putTemporary(String key, Serializable value) {
        this.guavaCache.putTemporary(key, value);
        this.redisCache.putTemporary(key, value);
    }

    @Override
    public void remove(String key) {
        if (StrUtil.isBlank(key)) {
            return;
        }
        this.guavaCache.remove(key);
        this.redisCache.remove(key);
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, key, CacheChangeType.REMOVE);
        topic.publish((Object)cacheChangedVo);
    }

    @Override
    public long ttl(String key) {
        return this.redisCache.ttl(key);
    }

    static {
        inited = false;
    }
}

