/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.model.Element;
import org.apache.log4j.Logger;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.ServiceDocument;
import org.swordapp.server.ServiceDocumentManager;
import org.swordapp.server.SwordAPIEndpoint;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class ServiceDocumentAPI
extends SwordAPIEndpoint {
    private static Logger log = Logger.getLogger(ServiceDocumentAPI.class);
    protected ServiceDocumentManager sdm;

    public ServiceDocumentAPI(ServiceDocumentManager sdm, SwordConfiguration config) {
        super(config);
        this.sdm = sdm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.get(req, resp);
        AuthCredentials auth = null;
        try {
            auth = this.getAuthCredentials(req);
        }
        catch (SwordAuthException e) {
            if (e.isRetry()) {
                String s = "Basic realm=\"SWORD2\"";
                resp.setHeader("WWW-Authenticate", s);
                resp.setStatus(401);
                return;
            }
            resp.sendError(400, e.getMessage());
            return;
        }
        try {
            String sdUri = this.getFullUrl(req);
            ServiceDocument serviceDocument = this.sdm.getServiceDocument(sdUri, auth, this.config);
            this.addGenerator(serviceDocument, this.config);
            resp.setHeader("Content-Type", "application/atomserv+xml");
            serviceDocument.getAbderaService().writeTo((Writer)resp.getWriter());
        }
        catch (SwordError se) {
            this.swordError(req, resp, se);
        }
        catch (SwordServerException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SwordAuthException e) {
            resp.sendError(403);
        }
        finally {
            resp.getWriter().flush();
        }
    }

    protected void addGenerator(ServiceDocument doc, SwordConfiguration config) {
        Element generator = this.getGenerator(this.config);
        if (generator != null) {
            doc.getWrappedService().addExtension(generator);
        }
    }
}

