/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScript;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.runtime.MagicScriptRuntime;
import org.ssssssss.script.runtime.RuntimeContext;
import org.ssssssss.script.runtime.Variables;

public class MagicScriptContext {
    private final Map<String, Object> rootVariables = new LinkedHashMap<String, Object>();
    private final List<String> importPackages = new ArrayList<String>();
    private MagicScriptRuntime runtime;
    private Variables variables;
    private String scriptName;

    public MagicScriptContext() {
    }

    public MagicScriptContext(Map<String, Object> variables) {
        this.putMapIntoContext(variables);
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getString(String name) {
        return Objects.toString(this.get(name), null);
    }

    public void addImport(String packageName) {
        this.importPackages.add(packageName);
    }

    public Class<?> getImportClass(String simpleClassName) {
        for (int i = this.importPackages.size() - 1; i >= 0; --i) {
            try {
                return Class.forName(this.importPackages.get(i) + simpleClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return null;
    }

    public Object get(String name) {
        return this.rootVariables.get(name);
    }

    public MagicScriptContext set(String name, Object value) {
        this.rootVariables.put(name, value);
        return this;
    }

    public Variables createVariables(MagicScriptRuntime runtime, int size) {
        this.runtime = runtime;
        this.variables = new Variables(size);
        return this.variables;
    }

    public Variables getVariables() {
        return this.variables;
    }

    public Object eval(RuntimeContext runtimeContext, String script) {
        LinkedHashMap<String, Object> varMap = new LinkedHashMap<String, Object>(runtimeContext.getScriptContext().getRootVariables());
        varMap.putAll(runtimeContext.getVariables().getVariables(runtimeContext.getScriptContext()));
        return this.eval(script, varMap);
    }

    public Object eval(String script, Map<String, Object> varMap) {
        try {
            MagicScript magicScript = MagicScript.create(true, script, null);
            MagicScriptRuntime runtime = magicScript.compile();
            MagicScriptContext context = new MagicScriptContext(varMap);
            context.setScriptName(this.getScriptName());
            return runtime.execute(context);
        }
        catch (Exception e) {
            Throwable throwable = MagicScriptError.unwrap(e);
            if (throwable instanceof MagicScriptException) {
                throw new RuntimeException(((MagicScriptException)throwable).getSimpleMessage());
            }
            throw new RuntimeException(throwable);
        }
    }

    public String[] getVarNames() {
        return this.runtime.getVarNames();
    }

    public Map<String, Object> getRootVariables() {
        return this.rootVariables;
    }

    public void putMapIntoContext(Map<String, Object> map) {
        if (map != null && !map.isEmpty()) {
            this.rootVariables.putAll(map);
        }
    }

    public Object getEnvironmentValue(String name) {
        Class<?> value = this.get(name);
        value = value == null ? this.getImportClass(name) : value;
        return value == null ? MagicResourceLoader.findClass(name) : value;
    }

    public void pause(int startRow, int startCol, int endRow, int endCol, Variables variables) throws InterruptedException {
    }
}

