/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.git;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.ssssssss.magicapi.core.resource.FileResource;
import org.ssssssss.magicapi.core.resource.Resource;
import org.ssssssss.magicapi.git.GitRepo;
import org.ssssssss.magicapi.git.MagicGitProperties;
import org.ssssssss.magicapi.utils.IoUtils;

public class GitResource
extends FileResource {
    private final GitRepo gitRepo;

    public static GitResource of(org.ssssssss.magicapi.core.config.Resource config, MagicGitProperties properties) throws IOException, GitAPIException {
        File file = new File(config.getLocation());
        GitRepo gitRepo = new GitRepo(file.getAbsolutePath(), properties);
        GitResource gitResource = new GitResource(config.isReadonly(), file, file.getAbsolutePath(), gitRepo);
        gitResource.setup();
        return gitResource;
    }

    public GitResource(boolean readonly, File file, String rootPath, GitRepo gitRepo) {
        super(file, readonly, rootPath);
        this.gitRepo = gitRepo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup() throws IOException, GitAPIException {
        Class<GitResource> clazz = GitResource.class;
        synchronized (GitResource.class) {
            this.gitRepo.setupRepo();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean update(boolean update) {
        return this.gitRepo.update(update);
    }

    public boolean delete() {
        return super.delete() && this.update(true);
    }

    public boolean mkdir() {
        return super.mkdir() && this.update(false);
    }

    public Resource getResource(String name) {
        return new GitResource(super.readonly(), new File(this.file, name), this.rootPath, this.gitRepo);
    }

    public Resource getDirectory(String name) {
        return this.getResource(name);
    }

    public boolean write(byte[] bytes) {
        return super.write(bytes) && this.update(false);
    }

    public boolean write(String content) {
        return super.write(content) && this.update(false);
    }

    public List<Resource> resources() {
        File[] files = this.file.listFiles();
        return files == null ? Collections.emptyList() : Arrays.stream(files).map(it -> new GitResource(this.readonly(), (File)it, this.rootPath, this.gitRepo)).collect(Collectors.toList());
    }

    public Resource parent() {
        return this.rootPath.equals(this.file.getAbsolutePath()) ? null : new GitResource(this.readonly(), this.file.getParentFile(), this.rootPath, this.gitRepo);
    }

    public List<Resource> dirs() {
        return IoUtils.dirs((File)this.file).stream().map(it -> new GitResource(this.readonly(), (File)it, this.rootPath, this.gitRepo)).collect(Collectors.toList());
    }

    public List<Resource> files(String suffix) {
        return IoUtils.files((File)this.file, (String)suffix).stream().map(it -> new GitResource(this.readonly(), (File)it, this.rootPath, this.gitRepo)).collect(Collectors.toList());
    }

    public boolean renameTo(Resource resource) {
        File target;
        if (!this.readonly() && this.file.renameTo(target = ((GitResource)resource).file)) {
            this.file = target;
            this.update(false);
            this.update(true);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.gitRepo.getProperties().getUrl();
    }
}

