/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.AbstractResourceResolver;
import org.springframework.web.reactive.resource.ResourceHandlerUtils;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PathResourceResolver
extends AbstractResourceResolver {
    @Nullable
    private Resource[] allowedLocations;

    public void setAllowedLocations(Resource ... locations) {
        this.allowedLocations = locations;
    }

    @Nullable
    public Resource[] getAllowedLocations() {
        return this.allowedLocations;
    }

    @Override
    protected Mono<Resource> resolveResourceInternal(@Nullable ServerWebExchange exchange2, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return this.getResource(requestPath, locations);
    }

    @Override
    protected Mono<String> resolveUrlPathInternal(String path, List<? extends Resource> locations, ResourceResolverChain chain) {
        if (StringUtils.hasText((String)path)) {
            return this.getResource(path, locations).map(resource2 -> path);
        }
        return Mono.empty();
    }

    private Mono<Resource> getResource(String resourcePath, List<? extends Resource> locations) {
        return Flux.fromIterable(locations).concatMap(location -> this.getResource(resourcePath, (Resource)location)).next();
    }

    protected Mono<Resource> getResource(String resourcePath, Resource location) {
        try {
            Resource resource2 = ResourceHandlerUtils.createRelativeResource(location, resourcePath);
            if (resource2.isReadable()) {
                if (this.checkResource(resource2, location)) {
                    return Mono.just((Object)resource2);
                }
                if (this.logger.isWarnEnabled()) {
                    Resource[] allowed = this.getAllowedLocations();
                    this.logger.warn((Object)LogFormatUtils.formatValue((Object)("Resource path \"" + resourcePath + "\" was successfully resolved but resource \"" + String.valueOf(resource2) + "\" is neither under the current location \"" + String.valueOf(location) + "\" nor under any of the allowed locations " + String.valueOf(allowed != null ? Arrays.asList(allowed) : "[]")), (int)-1, (boolean)true));
                }
            }
            return Mono.empty();
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                String error = "Skip location [" + String.valueOf(location) + "] due to error";
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)error, (Throwable)ex);
                } else {
                    this.logger.debug((Object)(error + ": " + ex.getMessage()));
                }
            }
            return Mono.error((Throwable)ex);
        }
    }

    protected boolean checkResource(Resource resource2, Resource location) throws IOException {
        if (ResourceHandlerUtils.isResourceUnderLocation(location, resource2)) {
            return true;
        }
        if (this.getAllowedLocations() != null) {
            for (Resource current : this.getAllowedLocations()) {
                if (!ResourceHandlerUtils.isResourceUnderLocation(current, resource2)) continue;
                return true;
            }
        }
        return false;
    }
}

