/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClientException;
import org.springframework.web.reactive.function.client.WebClientUtils;

public class WebClientResponseException
extends WebClientException {
    private static final long serialVersionUID = 4127543205414951611L;
    private final HttpStatusCode statusCode;
    private final String statusText;
    private final byte[] responseBody;
    private final HttpHeaders headers;
    @Nullable
    private final Charset responseCharset;
    @Nullable
    private final transient HttpRequest request;
    @Nullable
    private transient Function<ResolvableType, ?> bodyDecodeFunction;

    public WebClientResponseException(int statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] body2, @Nullable Charset charset) {
        this(statusCode, statusText, headers, body2, charset, null);
    }

    public WebClientResponseException(int status, String reasonPhrase, @Nullable HttpHeaders headers, @Nullable byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
        this(HttpStatusCode.valueOf((int)status), reasonPhrase, headers, body2, charset, request);
    }

    public WebClientResponseException(HttpStatusCode statusCode, String reasonPhrase, @Nullable HttpHeaders headers, @Nullable byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
        this(WebClientResponseException.initMessage(statusCode, reasonPhrase, request), statusCode, reasonPhrase, headers, body2, charset, request);
    }

    private static String initMessage(HttpStatusCode status, String reasonPhrase, @Nullable HttpRequest request) {
        return status.value() + " " + reasonPhrase + (String)(request != null ? " from " + WebClientUtils.getRequestDescription(request.getMethod(), request.getURI()) : "");
    }

    public WebClientResponseException(String message, int statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] responseBody, @Nullable Charset charset) {
        this(message, statusCode, statusText, headers, responseBody, charset, null);
    }

    public WebClientResponseException(String message, int statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] responseBody, @Nullable Charset charset, @Nullable HttpRequest request) {
        this(message, HttpStatusCode.valueOf((int)statusCode), statusText, headers, responseBody, charset, request);
    }

    public WebClientResponseException(String message, HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] responseBody, @Nullable Charset charset, @Nullable HttpRequest request) {
        super(message);
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.headers = WebClientResponseException.copy(headers);
        this.responseBody = responseBody != null ? responseBody : new byte[]{};
        this.responseCharset = charset;
        this.request = request;
    }

    private static HttpHeaders copy(@Nullable HttpHeaders headers) {
        if (headers == null) {
            return HttpHeaders.EMPTY;
        }
        HttpHeaders result = new HttpHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            for (String value : (List)entry.getValue()) {
                result.add((String)entry.getKey(), value);
            }
        }
        return result;
    }

    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    @Deprecated(since="6.0")
    public int getRawStatusCode() {
        return this.statusCode.value();
    }

    public String getStatusText() {
        return this.statusText;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public byte[] getResponseBodyAsByteArray() {
        return this.responseBody;
    }

    public String getResponseBodyAsString() {
        return this.getResponseBodyAsString(StandardCharsets.ISO_8859_1);
    }

    public String getResponseBodyAsString(Charset defaultCharset) {
        return new String(this.responseBody, this.responseCharset != null ? this.responseCharset : defaultCharset);
    }

    @Nullable
    public <E> E getResponseBodyAs(Class<E> targetType) {
        return this.decodeBody(ResolvableType.forClass(targetType));
    }

    @Nullable
    public <E> E getResponseBodyAs(ParameterizedTypeReference<E> targetType) {
        return this.decodeBody(ResolvableType.forType((Type)targetType.getType()));
    }

    @Nullable
    private <E> E decodeBody(ResolvableType targetType) {
        Assert.state((this.bodyDecodeFunction != null ? 1 : 0) != 0, (String)"Decoder function not set");
        return (E)this.bodyDecodeFunction.apply(targetType);
    }

    @Nullable
    public HttpRequest getRequest() {
        return this.request;
    }

    public void setBodyDecodeFunction(Function<ResolvableType, ?> decoderFunction) {
        this.bodyDecodeFunction = decoderFunction;
    }

    public static WebClientResponseException create(int statusCode, String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
        return WebClientResponseException.create(statusCode, statusText, headers, body2, charset, null);
    }

    public static WebClientResponseException create(int statusCode, String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
        return WebClientResponseException.create(HttpStatusCode.valueOf((int)statusCode), statusText, headers, body2, charset, request);
    }

    public static WebClientResponseException create(HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus httpStatus = (HttpStatus)statusCode;
            switch (httpStatus) {
                case BAD_REQUEST: {
                    return new BadRequest(statusText, headers, body2, charset, request);
                }
                case UNAUTHORIZED: {
                    return new Unauthorized(statusText, headers, body2, charset, request);
                }
                case FORBIDDEN: {
                    return new Forbidden(statusText, headers, body2, charset, request);
                }
                case NOT_FOUND: {
                    return new NotFound(statusText, headers, body2, charset, request);
                }
                case METHOD_NOT_ALLOWED: {
                    return new MethodNotAllowed(statusText, headers, body2, charset, request);
                }
                case NOT_ACCEPTABLE: {
                    return new NotAcceptable(statusText, headers, body2, charset, request);
                }
                case CONFLICT: {
                    return new Conflict(statusText, headers, body2, charset, request);
                }
                case GONE: {
                    return new Gone(statusText, headers, body2, charset, request);
                }
                case UNSUPPORTED_MEDIA_TYPE: {
                    return new UnsupportedMediaType(statusText, headers, body2, charset, request);
                }
                case TOO_MANY_REQUESTS: {
                    return new TooManyRequests(statusText, headers, body2, charset, request);
                }
                case UNPROCESSABLE_ENTITY: {
                    return new UnprocessableEntity(statusText, headers, body2, charset, request);
                }
                case INTERNAL_SERVER_ERROR: {
                    return new InternalServerError(statusText, headers, body2, charset, request);
                }
                case NOT_IMPLEMENTED: {
                    return new NotImplemented(statusText, headers, body2, charset, request);
                }
                case BAD_GATEWAY: {
                    return new BadGateway(statusText, headers, body2, charset, request);
                }
                case SERVICE_UNAVAILABLE: {
                    return new ServiceUnavailable(statusText, headers, body2, charset, request);
                }
                case GATEWAY_TIMEOUT: {
                    return new GatewayTimeout(statusText, headers, body2, charset, request);
                }
            }
        }
        return new WebClientResponseException(statusCode, statusText, headers, body2, charset, request);
    }

    public static class BadRequest
    extends WebClientResponseException {
        BadRequest(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.BAD_REQUEST.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class Unauthorized
    extends WebClientResponseException {
        Unauthorized(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.UNAUTHORIZED.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class Forbidden
    extends WebClientResponseException {
        Forbidden(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.FORBIDDEN.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class NotFound
    extends WebClientResponseException {
        NotFound(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.NOT_FOUND.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class MethodNotAllowed
    extends WebClientResponseException {
        MethodNotAllowed(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.METHOD_NOT_ALLOWED.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class NotAcceptable
    extends WebClientResponseException {
        NotAcceptable(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.NOT_ACCEPTABLE.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class Conflict
    extends WebClientResponseException {
        Conflict(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.CONFLICT.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class Gone
    extends WebClientResponseException {
        Gone(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.GONE.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class UnsupportedMediaType
    extends WebClientResponseException {
        UnsupportedMediaType(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.UNSUPPORTED_MEDIA_TYPE.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class TooManyRequests
    extends WebClientResponseException {
        TooManyRequests(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.TOO_MANY_REQUESTS.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class UnprocessableEntity
    extends WebClientResponseException {
        UnprocessableEntity(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.UNPROCESSABLE_ENTITY.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class InternalServerError
    extends WebClientResponseException {
        InternalServerError(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.INTERNAL_SERVER_ERROR.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class NotImplemented
    extends WebClientResponseException {
        NotImplemented(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.NOT_IMPLEMENTED.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class BadGateway
    extends WebClientResponseException {
        BadGateway(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.BAD_GATEWAY.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class ServiceUnavailable
    extends WebClientResponseException {
        ServiceUnavailable(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.SERVICE_UNAVAILABLE.value(), statusText, headers, body2, charset, request);
        }
    }

    public static class GatewayTimeout
    extends WebClientResponseException {
        GatewayTimeout(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.GATEWAY_TIMEOUT.value(), statusText, headers, body2, charset, request);
        }
    }
}

