/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.FacesRequestAttributes;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesWebRequest
extends FacesRequestAttributes
implements NativeWebRequest {
    private MultipartRequest multipartRequest;

    public FacesWebRequest(FacesContext facesContext) {
        super(facesContext);
        if (facesContext.getExternalContext().getRequest() instanceof MultipartRequest) {
            this.multipartRequest = (MultipartRequest)facesContext.getExternalContext().getRequest();
        }
    }

    @Override
    public Object getNativeRequest() {
        return this.getExternalContext().getRequest();
    }

    @Override
    public Object getNativeResponse() {
        return this.getExternalContext().getResponse();
    }

    @Override
    public String getHeader(String headerName) {
        return (String)this.getExternalContext().getRequestHeaderMap().get(headerName);
    }

    @Override
    public String[] getHeaderValues(String headerName) {
        return (String[])this.getExternalContext().getRequestHeaderValuesMap().get(headerName);
    }

    @Override
    public Iterator<String> getHeaderNames() {
        return this.getExternalContext().getRequestHeaderMap().keySet().iterator();
    }

    @Override
    public String getParameter(String paramName) {
        return (String)this.getExternalContext().getRequestParameterMap().get(paramName);
    }

    @Override
    public Iterator<String> getParameterNames() {
        return this.getExternalContext().getRequestParameterNames();
    }

    @Override
    public String[] getParameterValues(String paramName) {
        return (String[])this.getExternalContext().getRequestParameterValuesMap().get(paramName);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.getExternalContext().getRequestParameterValuesMap();
    }

    @Override
    public Locale getLocale() {
        return this.getFacesContext().getExternalContext().getRequestLocale();
    }

    @Override
    public String getContextPath() {
        return this.getFacesContext().getExternalContext().getRequestContextPath();
    }

    @Override
    public String getRemoteUser() {
        return this.getFacesContext().getExternalContext().getRemoteUser();
    }

    @Override
    public Principal getUserPrincipal() {
        return this.getFacesContext().getExternalContext().getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.getFacesContext().getExternalContext().isUserInRole(role);
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean checkNotModified(long lastModifiedTimestamp) {
        return false;
    }

    @Override
    public String getDescription(boolean includeClientInfo) {
        ExternalContext externalContext = this.getExternalContext();
        StringBuilder sb = new StringBuilder();
        sb.append("context=").append(externalContext.getRequestContextPath());
        if (includeClientInfo) {
            String user;
            Object session = externalContext.getSession(false);
            if (session != null) {
                sb.append(";session=").append(this.getSessionId());
            }
            if (StringUtils.hasLength((String)(user = externalContext.getRemoteUser()))) {
                sb.append(";user=").append(user);
            }
        }
        return sb.toString();
    }

    @Override
    public Iterator<String> getFileNames() {
        if (this.multipartRequest == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return this.multipartRequest.getFileNames();
    }

    @Override
    public MultipartFile getFile(String name) {
        if (this.multipartRequest == null) {
            return null;
        }
        return this.multipartRequest.getFile(name);
    }

    @Override
    public List<MultipartFile> getFiles(String name) {
        if (this.multipartRequest == null) {
            return null;
        }
        return this.multipartRequest.getFiles(name);
    }

    @Override
    public Map<String, MultipartFile> getFileMap() {
        if (this.multipartRequest == null) {
            return Collections.emptyMap();
        }
        return this.multipartRequest.getFileMap();
    }

    @Override
    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        if (this.multipartRequest == null) {
            return new LinkedMultiValueMap();
        }
        return this.multipartRequest.getMultiFileMap();
    }

    public String toString() {
        return "FacesWebRequest: " + this.getDescription(true);
    }
}

