/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;

public class DefaultResponseErrorHandler
implements ResponseErrorHandler {
    public boolean hasError(ClientHttpResponse response) throws IOException {
        return this.hasError(response.getStatusCode());
    }

    protected boolean hasError(HttpStatus statusCode) {
        return statusCode.series() == HttpStatus.Series.CLIENT_ERROR || statusCode.series() == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = response.getStatusCode();
        switch (statusCode.series()) {
            case CLIENT_ERROR: {
                throw new HttpClientErrorException(statusCode, response.getStatusText());
            }
            case SERVER_ERROR: {
                throw new HttpServerErrorException(statusCode, response.getStatusText());
            }
        }
        throw new RestClientException("Unknown status code [" + (Object)((Object)statusCode) + "]");
    }
}

