/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.RequestMatcherFactory;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.RequestMatcherRedirectFilter;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.util.Assert;

public final class PasswordManagementConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<PasswordManagementConfigurer<B>, B> {
    private static final String WELL_KNOWN_CHANGE_PASSWORD_PATTERN = "/.well-known/change-password";
    private static final String DEFAULT_CHANGE_PASSWORD_PAGE = "/change-password";
    private String changePasswordPage = "/change-password";

    public PasswordManagementConfigurer<B> changePasswordPage(String changePasswordPage) {
        Assert.hasText((String)changePasswordPage, (String)"changePasswordPage cannot be empty");
        this.changePasswordPage = changePasswordPage;
        return this;
    }

    @Override
    public void configure(B http) throws Exception {
        RequestMatcherRedirectFilter changePasswordFilter = new RequestMatcherRedirectFilter(RequestMatcherFactory.matcher(WELL_KNOWN_CHANGE_PASSWORD_PATTERN), this.changePasswordPage);
        http.addFilterBefore((Filter)this.postProcess(changePasswordFilter), UsernamePasswordAuthenticationFilter.class);
    }
}

