/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.outbound;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.support.converter.SimpleMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public class RedisPublishingMessageHandler
extends AbstractMessageHandler {
    private final RedisTemplate<?, ?> template;
    private volatile EvaluationContext evaluationContext;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile RedisSerializer<?> serializer = new StringRedisSerializer();
    private volatile Expression topicExpression;

    public RedisPublishingMessageHandler(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory must not be null");
        this.template = new RedisTemplate();
        this.template.setConnectionFactory(connectionFactory);
        this.template.setEnableDefaultSerializer(false);
        this.template.afterPropertiesSet();
    }

    public void setSerializer(RedisSerializer<?> serializer) {
        Assert.notNull(serializer, (String)"'serializer' must not be null");
        this.serializer = serializer;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"messageConverter must not be null");
        this.messageConverter = messageConverter;
    }

    public void setTopic(String topic) {
        Assert.hasText((String)topic, (String)"'topic' must not be an empty string.");
        this.setTopicExpression((Expression)new LiteralExpression(topic));
    }

    public void setTopicExpression(Expression topicExpression) {
        Assert.notNull((Object)topicExpression, (String)"'topicExpression' must not be null.");
        this.topicExpression = topicExpression;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public String getComponentType() {
        return "redis:outbound-channel-adapter";
    }

    protected void onInit() {
        Assert.notNull((Object)this.topicExpression, (String)"'topicExpression' must not be null.");
        if (this.messageConverter instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.messageConverter).setBeanFactory(this.getBeanFactory());
        }
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        }
    }

    protected void handleMessageInternal(Message<?> message) {
        String topic = (String)this.topicExpression.getValue(this.evaluationContext, message, String.class);
        Object value = this.messageConverter.fromMessage(message, Object.class);
        if (value instanceof byte[]) {
            this.template.convertAndSend(topic, value);
        } else {
            this.template.convertAndSend(topic, (Object)this.serializer.serialize(value));
        }
    }
}

