/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.integration.http.inbound.HttpRequestHandlingEndpointSupport;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.MapBindingResult;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.Controller;

public class HttpRequestHandlingController
extends HttpRequestHandlingEndpointSupport
implements Controller {
    private static final String DEFAULT_ERROR_CODE = "spring.integration.http.handler.error";
    private static final String DEFAULT_REPLY_KEY = "reply";
    private static final String DEFAULT_ERRORS_KEY = "errors";
    private volatile Expression viewExpression;
    private volatile StandardEvaluationContext evaluationContext;
    private volatile String replyKey = "reply";
    private volatile String errorsKey = "errors";
    private volatile String errorCode = "spring.integration.http.handler.error";

    public HttpRequestHandlingController() {
        this(true);
    }

    public HttpRequestHandlingController(boolean expectReply) {
        super(expectReply);
    }

    public void setViewName(String viewName) {
        Assert.isTrue((boolean)StringUtils.hasText((String)viewName), (String)"View name must contain text");
        this.viewExpression = new LiteralExpression(viewName);
    }

    public void setReplyKey(String replyKey) {
        this.replyKey = replyKey != null ? replyKey : DEFAULT_REPLY_KEY;
    }

    public void setErrorsKey(String errorsKey) {
        this.errorsKey = errorsKey;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setViewExpression(Expression viewExpression) {
        this.viewExpression = viewExpression;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        this.evaluationContext = this.createEvaluationContext();
    }

    public final ModelAndView handleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        ModelAndView modelAndView;
        block6: {
            modelAndView = new ModelAndView();
            try {
                Message<?> replyMessage = super.doHandleRequest(servletRequest, servletResponse);
                ServletServerHttpResponse response = new ServletServerHttpResponse(servletResponse);
                if (replyMessage != null) {
                    Object reply = this.setupResponseAndConvertReply(response, replyMessage);
                    response.close();
                    modelAndView.addObject(this.replyKey, reply);
                } else {
                    this.setStatusCodeIfNeeded((ServerHttpResponse)response);
                }
                if (this.viewExpression == null) break block6;
                Object view = replyMessage != null ? this.viewExpression.getValue((EvaluationContext)this.evaluationContext, replyMessage) : this.viewExpression.getValue((EvaluationContext)this.evaluationContext);
                if (view instanceof View) {
                    modelAndView.setView((View)view);
                    break block6;
                }
                if (view instanceof String) {
                    modelAndView.setViewName((String)view);
                    break block6;
                }
                throw new IllegalStateException("view expression must resolve to a View or String");
            }
            catch (Exception e) {
                MapBindingResult errors = new MapBindingResult(new HashMap(), "dummy");
                PrintWriter stackTrace = new PrintWriter(new StringWriter());
                e.printStackTrace(stackTrace);
                errors.reject(this.errorCode, new Object[]{e, e.getMessage(), stackTrace.toString()}, "A Spring Integration handler raised an exception while handling an HTTP request.  The exception is of type " + e.getClass() + " and it has a message: (" + e.getMessage() + ")");
                modelAndView.addObject(this.errorsKey, (Object)errors);
            }
        }
        return modelAndView;
    }
}

