/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.util;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public abstract class UriUtils {
    private static AnnotationMappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(RequestMapping.class);

    private UriUtils() {
    }

    public static String findMappingVariable(String variable, Method method, String lookupPath) {
        Assert.hasText((String)variable, (String)"Variable name must not be null or empty!");
        Assert.notNull((Object)method, (String)"Method must not be null!");
        String mapping = DISCOVERER.getMapping(method);
        Map variables = new UriTemplate(mapping).match(lookupPath);
        String value = (String)variables.get(variable);
        if (value != null) {
            return value;
        }
        return null;
    }

    public static List<String> getPathSegments(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        String mapping = DISCOVERER.getMapping(method.getDeclaringClass(), method);
        return UriComponentsBuilder.fromPath((String)mapping).build().getPathSegments();
    }
}

