/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.serializer.JacksonObjectReader;
import org.springframework.data.redis.serializer.JacksonObjectWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.util.Assert;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.type.TypeFactory;

public class JacksonJsonRedisSerializer<T>
implements RedisSerializer<T> {
    private final JavaType javaType;
    private final ObjectMapper mapper;
    private final JacksonObjectReader reader;
    private final JacksonObjectWriter writer;

    public JacksonJsonRedisSerializer(Class<T> type) {
        this((ObjectMapper)JsonMapper.shared(), type);
    }

    public JacksonJsonRedisSerializer(JavaType javaType) {
        this((ObjectMapper)JsonMapper.shared(), javaType);
    }

    public JacksonJsonRedisSerializer(ObjectMapper mapper, Class<T> type) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull(type, (String)"Java type must not be null");
        this.javaType = this.getJavaType(type);
        this.mapper = mapper;
        this.reader = JacksonObjectReader.create();
        this.writer = JacksonObjectWriter.create();
    }

    public JacksonJsonRedisSerializer(ObjectMapper mapper, JavaType javaType) {
        this(mapper, javaType, JacksonObjectReader.create(), JacksonObjectWriter.create());
    }

    public JacksonJsonRedisSerializer(ObjectMapper mapper, JavaType javaType, JacksonObjectReader reader, JacksonObjectWriter writer) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)reader, (String)"Reader must not be null");
        Assert.notNull((Object)writer, (String)"Writer must not be null");
        this.mapper = mapper;
        this.reader = reader;
        this.writer = writer;
        this.javaType = javaType;
    }

    @Override
    public byte[] serialize(@Nullable T value) throws SerializationException {
        if (value == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        try {
            return this.writer.write(this.mapper, value);
        }
        catch (RuntimeException ex) {
            throw new SerializationException("Could not write JSON: " + ex.getMessage(), ex);
        }
    }

    @Override
    public @Nullable T deserialize(byte @Nullable [] bytes) throws SerializationException {
        if (SerializationUtils.isEmpty(bytes)) {
            return null;
        }
        try {
            return (T)this.reader.read(this.mapper, bytes, this.javaType);
        }
        catch (RuntimeException ex) {
            throw new SerializationException("Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    protected JavaType getJavaType(Class<?> clazz) {
        return TypeFactory.unsafeSimpleType(clazz);
    }
}

