/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.AbstractIndexTemplate;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.ResponseConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class RestIndexTemplate
extends AbstractIndexTemplate
implements IndexOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestIndexTemplate.class);
    private final ElasticsearchRestTemplate restTemplate;

    public RestIndexTemplate(ElasticsearchRestTemplate restTemplate, Class<?> boundClass) {
        super(restTemplate.getElasticsearchConverter(), boundClass);
        this.restTemplate = restTemplate;
    }

    public RestIndexTemplate(ElasticsearchRestTemplate restTemplate, IndexCoordinates boundIndex) {
        super(restTemplate.getElasticsearchConverter(), boundIndex);
        this.restTemplate = restTemplate;
    }

    @Override
    protected boolean doCreate(IndexCoordinates index, Map<String, Object> settings, @Nullable Document mapping) {
        CreateIndexRequest request = this.requestFactory.createIndexRequest(index, settings, mapping);
        return this.restTemplate.execute(client -> client.indices().create(request, RequestOptions.DEFAULT).isAcknowledged());
    }

    @Override
    protected boolean doDelete(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        if (this.doExists(index)) {
            DeleteIndexRequest deleteIndexRequest = this.requestFactory.deleteIndexRequest(index);
            return this.restTemplate.execute(client -> client.indices().delete(deleteIndexRequest, RequestOptions.DEFAULT).isAcknowledged());
        }
        return false;
    }

    @Override
    protected boolean doExists(IndexCoordinates index) {
        GetIndexRequest getIndexRequest = this.requestFactory.getIndexRequest(index);
        return this.restTemplate.execute(client -> client.indices().exists(getIndexRequest, RequestOptions.DEFAULT));
    }

    @Override
    protected boolean doPutMapping(IndexCoordinates index, Document mapping) {
        Assert.notNull((Object)index, (String)"No index defined for putMapping()");
        PutMappingRequest request = this.requestFactory.putMappingRequest(index, mapping);
        return this.restTemplate.execute(client -> client.indices().putMapping(request, RequestOptions.DEFAULT).isAcknowledged());
    }

    @Override
    protected Map<String, Object> doGetMapping(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for getMapping()");
        GetMappingsRequest mappingsRequest = this.requestFactory.getMappingsRequest(index);
        return this.restTemplate.execute(client -> {
            Map mappings = client.indices().getMapping(mappingsRequest, RequestOptions.DEFAULT).mappings();
            if (mappings == null || mappings.size() == 0) {
                return Collections.emptyMap();
            }
            if (mappings.size() > 1) {
                LOGGER.warn("more than one mapping returned for " + index.getIndexName());
            }
            return ((MappingMetadata)mappings.entrySet().iterator().next().getValue()).getSourceAsMap();
        });
    }

    @Override
    protected Map<String, Set<AliasData>> doGetAliases(@Nullable String[] aliasNames, @Nullable String[] indexNames) {
        GetAliasesRequest getAliasesRequest = this.requestFactory.getAliasesRequest(aliasNames, indexNames);
        return this.restTemplate.execute(client -> ResponseConverter.aliasDatas(client.indices().getAlias(getAliasesRequest, RequestOptions.DEFAULT).getAliases()));
    }

    @Override
    public boolean alias(AliasActions aliasActions) {
        IndicesAliasesRequest request = this.requestFactory.indicesAliasesRequest(aliasActions);
        return this.restTemplate.execute(client -> client.indices().updateAliases(request, RequestOptions.DEFAULT).isAcknowledged());
    }

    @Override
    protected Settings doGetSettings(IndexCoordinates index, boolean includeDefaults) {
        Assert.notNull((Object)index, (String)"index must not be null");
        GetSettingsRequest getSettingsRequest = this.requestFactory.getSettingsRequest(index, includeDefaults);
        GetSettingsResponse response = this.restTemplate.execute(client -> client.indices().getSettings(getSettingsRequest, RequestOptions.DEFAULT));
        return ResponseConverter.fromSettingsResponse(response, getSettingsRequest.indices()[0]);
    }

    @Override
    protected void doRefresh(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for refresh()");
        RefreshRequest refreshRequest = this.requestFactory.refreshRequest(index);
        this.restTemplate.execute(client -> client.indices().refresh(refreshRequest, RequestOptions.DEFAULT));
    }

    @Override
    public boolean putTemplate(PutTemplateRequest putTemplateRequest) {
        Assert.notNull((Object)putTemplateRequest, (String)"putTemplateRequest must not be null");
        PutIndexTemplateRequest putIndexTemplateRequest = this.requestFactory.putIndexTemplateRequest(putTemplateRequest);
        return this.restTemplate.execute(client -> client.indices().putTemplate(putIndexTemplateRequest, RequestOptions.DEFAULT).isAcknowledged());
    }

    @Override
    public TemplateData getTemplate(GetTemplateRequest getTemplateRequest) {
        Assert.notNull((Object)getTemplateRequest, (String)"getTemplateRequest must not be null");
        if (!this.existsTemplate(new ExistsTemplateRequest(getTemplateRequest.getTemplateName()))) {
            return null;
        }
        GetIndexTemplatesRequest getIndexTemplatesRequest = this.requestFactory.getIndexTemplatesRequest(getTemplateRequest);
        GetIndexTemplatesResponse getIndexTemplatesResponse = this.restTemplate.execute(client -> client.indices().getIndexTemplate(getIndexTemplatesRequest, RequestOptions.DEFAULT));
        return ResponseConverter.getTemplateData(getIndexTemplatesResponse, getTemplateRequest.getTemplateName());
    }

    @Override
    public boolean existsTemplate(ExistsTemplateRequest existsTemplateRequest) {
        Assert.notNull((Object)existsTemplateRequest, (String)"existsTemplateRequest must not be null");
        IndexTemplatesExistRequest putIndexTemplateRequest = this.requestFactory.indexTemplatesExistsRequest(existsTemplateRequest);
        return this.restTemplate.execute(client -> client.indices().existsTemplate(putIndexTemplateRequest, RequestOptions.DEFAULT));
    }

    @Override
    public boolean deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) {
        Assert.notNull((Object)deleteTemplateRequest, (String)"deleteTemplateRequest must not be null");
        DeleteIndexTemplateRequest deleteIndexTemplateRequest = this.requestFactory.deleteIndexTemplateRequest(deleteTemplateRequest);
        return this.restTemplate.execute(client -> client.indices().deleteTemplate(deleteIndexTemplateRequest, RequestOptions.DEFAULT).isAcknowledged());
    }

    @Override
    public List<IndexInformation> getInformation(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        GetIndexRequest request = this.requestFactory.getIndexRequest(index);
        return this.restTemplate.execute(client -> {
            GetIndexResponse getIndexResponse = client.indices().get(request, RequestOptions.DEFAULT);
            return ResponseConverter.getIndexInformations(getIndexResponse);
        });
    }
}

