/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class EurekaDiscoveryClient
implements DiscoveryClient {
    public static final String DESCRIPTION = "Spring Cloud Eureka Discovery Client";
    private final EurekaInstanceConfig config;
    private final EurekaClient eurekaClient;

    public String description() {
        return DESCRIPTION;
    }

    public ServiceInstance getLocalServiceInstance() {
        return new ServiceInstance(){

            public String getServiceId() {
                return EurekaDiscoveryClient.this.config.getAppname();
            }

            public String getHost() {
                return EurekaDiscoveryClient.this.config.getHostName(false);
            }

            public int getPort() {
                return EurekaDiscoveryClient.this.config.getNonSecurePort();
            }

            public boolean isSecure() {
                return EurekaDiscoveryClient.this.config.getSecurePortEnabled();
            }

            public URI getUri() {
                return DefaultServiceInstance.getUri((ServiceInstance)this);
            }

            public Map<String, String> getMetadata() {
                return EurekaDiscoveryClient.this.config.getMetadataMap();
            }
        };
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        List infos = this.eurekaClient.getInstancesByVipAddress(serviceId, false);
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        for (InstanceInfo info : infos) {
            instances.add(new EurekaServiceInstance(info));
        }
        return instances;
    }

    public List<String> getServices() {
        Applications applications = this.eurekaClient.getApplications();
        if (applications == null) {
            return Collections.emptyList();
        }
        List registered = applications.getRegisteredApplications();
        ArrayList<String> names = new ArrayList<String>();
        for (Application app : registered) {
            if (app.getInstances().isEmpty()) continue;
            names.add(app.getName().toLowerCase());
        }
        return names;
    }

    @ConstructorProperties(value={"config", "eurekaClient"})
    public EurekaDiscoveryClient(EurekaInstanceConfig config, EurekaClient eurekaClient) {
        this.config = config;
        this.eurekaClient = eurekaClient;
    }

    public static class EurekaServiceInstance
    implements ServiceInstance {
        private InstanceInfo instance;

        EurekaServiceInstance(InstanceInfo instance) {
            this.instance = instance;
        }

        public InstanceInfo getInstanceInfo() {
            return this.instance;
        }

        public String getServiceId() {
            return this.instance.getAppName();
        }

        public String getHost() {
            return this.instance.getHostName();
        }

        public int getPort() {
            if (this.isSecure()) {
                return this.instance.getSecurePort();
            }
            return this.instance.getPort();
        }

        public boolean isSecure() {
            return this.instance.isPortEnabled(InstanceInfo.PortType.SECURE);
        }

        public URI getUri() {
            return DefaultServiceInstance.getUri((ServiceInstance)this);
        }

        public Map<String, String> getMetadata() {
            return this.instance.getMetadata();
        }
    }
}

