/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.util.function.Function;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.support.NameUtils;
import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.DefaultValueStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.util.ClassUtils;

public class GatewayToStringStyler
extends DefaultToStringStyler {
    private static final GatewayToStringStyler FILTER_INSTANCE = new GatewayToStringStyler(GatewayFilterFactory.class, NameUtils::normalizeFilterFactoryName);
    private final Function<Class, String> classNameFormatter;
    private final Class instanceClass;

    public static ToStringCreator filterToStringCreator(Object obj) {
        return new ToStringCreator(obj, (ToStringStyler)FILTER_INSTANCE);
    }

    public GatewayToStringStyler(Class instanceClass, Function<Class, String> classNameFormatter) {
        super((ValueStyler)new DefaultValueStyler());
        this.classNameFormatter = classNameFormatter;
        this.instanceClass = instanceClass;
    }

    public void styleStart(StringBuilder buffer, Object obj) {
        if (!obj.getClass().isArray()) {
            String shortName = this.instanceClass.isInstance(obj) ? this.classNameFormatter.apply(obj.getClass()) : ClassUtils.getShortName(obj.getClass());
            buffer.append('[').append(shortName);
        } else {
            buffer.append('[');
            this.styleValue(buffer, obj);
        }
    }
}

