/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.cloud.contract.spec.internal.Input;
import org.springframework.cloud.contract.spec.internal.OutputMessage;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.spec.internal.Response;

public class Contract {
    private Integer priority;
    private Request request;
    private Response response;
    private String label;
    private String description;
    private String name;
    private Input input;
    private OutputMessage outputMessage;
    private boolean ignored;
    private boolean inProgress;

    public void priority(int priority) {
        this.priority = priority;
    }

    public void name(String name) {
        this.name = name;
    }

    public void label(String label) {
        this.label = label;
    }

    public void description(String description) {
        this.description = description;
    }

    public static void assertContract(Contract dsl) {
        if (dsl.getRequest() != null) {
            if (dsl.request.getUrl() == null && dsl.request.getUrlPath() == null) {
                throw new IllegalStateException("URL is missing for HTTP contract(exclude = { TraceWebClientAutoConfiguration.class })");
            }
            if (dsl.request.getMethod() == null) {
                throw new IllegalStateException("Method is missing for HTTP contract");
            }
        }
        if (dsl.response != null && dsl.response.getStatus() == null) {
            throw new IllegalStateException("Status is missing for HTTP contract");
        }
    }

    public static Contract make(Consumer<Contract> consumer) {
        Contract contract = new Contract();
        consumer.accept(contract);
        return contract;
    }

    public static Contract make(@DelegatesTo(value=Contract.class) Closure closure) {
        Contract dsl = new Contract();
        closure.setDelegate((Object)dsl);
        closure.call();
        Contract.assertContract(dsl);
        return dsl;
    }

    public void request(Consumer<Request> consumer) {
        this.request = new Request();
        consumer.accept(this.request);
    }

    public void response(Consumer<Response> consumer) {
        this.response = new Response();
        consumer.accept(this.response);
    }

    public void input(Consumer<Input> consumer) {
        this.input = new Input();
        consumer.accept(this.input);
    }

    public void outputMessage(Consumer<OutputMessage> consumer) {
        this.outputMessage = new OutputMessage();
        consumer.accept(this.outputMessage);
    }

    public void request(@DelegatesTo(value=Request.class) Closure consumer) {
        this.request = new Request();
        consumer.setDelegate((Object)this.request);
        consumer.call();
    }

    public void response(@DelegatesTo(value=Response.class) Closure consumer) {
        this.response = new Response();
        consumer.setDelegate((Object)this.response);
        consumer.call();
    }

    public void input(@DelegatesTo(value=Input.class) Closure consumer) {
        this.input = new Input();
        consumer.setDelegate((Object)this.input);
        consumer.call();
    }

    public void outputMessage(@DelegatesTo(value=OutputMessage.class) Closure consumer) {
        this.outputMessage = new OutputMessage();
        consumer.setDelegate((Object)this.outputMessage);
        consumer.call();
    }

    public void ignored() {
        this.ignored = true;
    }

    public void inProgress() {
        this.inProgress = true;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Input getInput() {
        return this.input;
    }

    public void setInput(Input input) {
        this.input = input;
    }

    public OutputMessage getOutputMessage() {
        return this.outputMessage;
    }

    public void setOutputMessage(OutputMessage outputMessage) {
        this.outputMessage = outputMessage;
    }

    public boolean getIgnored() {
        return this.ignored;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean getInProgress() {
        return this.inProgress;
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contract contract = (Contract)o;
        return this.ignored == contract.ignored && Objects.equals(this.priority, contract.priority) && Objects.equals(this.request, contract.request) && Objects.equals(this.response, contract.response) && Objects.equals(this.label, contract.label) && Objects.equals(this.description, contract.description) && Objects.equals(this.name, contract.name) && Objects.equals(this.input, contract.input) && Objects.equals(this.outputMessage, contract.outputMessage);
    }

    public int hashCode() {
        return Objects.hash(this.priority, this.request, this.response, this.label, this.description, this.name, this.input, this.outputMessage, this.ignored);
    }

    public String toString() {
        return "Contract{\npriority=" + this.priority + ", \n\trequest=" + this.request + ", \n\tresponse=" + this.response + ", \n\tlabel='" + this.label + '\'' + ", \n\tdescription='" + this.description + '\'' + ", \n\tname='" + this.name + '\'' + ", \n\tinput=" + this.input + ", \n\toutputMessage=" + this.outputMessage + ", \n\tignored=" + this.ignored + '}';
    }
}

