/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.autoconfigure;

import java.net.InetAddress;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.boot.web.server.Compression;
import org.springframework.boot.web.server.Cookie;
import org.springframework.boot.web.server.Http2;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.servlet.Jsp;
import org.springframework.boot.web.server.servlet.Session;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="server")
public class ServerProperties {
    private @Nullable Integer port;
    private @Nullable InetAddress address;
    @NestedConfigurationProperty
    private final ErrorProperties error = new ErrorProperties();
    private @Nullable ForwardHeadersStrategy forwardHeadersStrategy;
    private @Nullable String serverHeader;
    private DataSize maxHttpRequestHeaderSize = DataSize.ofKilobytes((long)8L);
    private Shutdown shutdown = Shutdown.GRACEFUL;
    @NestedConfigurationProperty
    private @Nullable Ssl ssl;
    @NestedConfigurationProperty
    private final Compression compression = new Compression();
    private final MimeMappings mimeMappings = new MimeMappings();
    @NestedConfigurationProperty
    private final Http2 http2 = new Http2();
    private final Servlet servlet = new Servlet();
    private final Reactive reactive = new Reactive();

    public @Nullable Integer getPort() {
        return this.port;
    }

    public void setPort(@Nullable Integer port) {
        this.port = port;
    }

    public @Nullable InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(@Nullable InetAddress address) {
        this.address = address;
    }

    public @Nullable String getServerHeader() {
        return this.serverHeader;
    }

    public void setServerHeader(@Nullable String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public DataSize getMaxHttpRequestHeaderSize() {
        return this.maxHttpRequestHeaderSize;
    }

    public void setMaxHttpRequestHeaderSize(DataSize maxHttpRequestHeaderSize) {
        this.maxHttpRequestHeaderSize = maxHttpRequestHeaderSize;
    }

    public Shutdown getShutdown() {
        return this.shutdown;
    }

    public void setShutdown(Shutdown shutdown) {
        this.shutdown = shutdown;
    }

    public ErrorProperties getError() {
        return this.error;
    }

    public @Nullable Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(@Nullable Ssl ssl) {
        this.ssl = ssl;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public MimeMappings getMimeMappings() {
        return this.mimeMappings;
    }

    public void setMimeMappings(Map<String, String> customMappings) {
        customMappings.forEach(this.mimeMappings::add);
    }

    public Http2 getHttp2() {
        return this.http2;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public Reactive getReactive() {
        return this.reactive;
    }

    public @Nullable ForwardHeadersStrategy getForwardHeadersStrategy() {
        return this.forwardHeadersStrategy;
    }

    public void setForwardHeadersStrategy(@Nullable ForwardHeadersStrategy forwardHeadersStrategy) {
        this.forwardHeadersStrategy = forwardHeadersStrategy;
    }

    public static class Servlet {
        private final Map<String, String> contextParameters = new HashMap<String, String>();
        private @Nullable String contextPath;
        private String applicationDisplayName = "application";
        private boolean registerDefaultServlet = false;
        private final Encoding encoding = new Encoding();
        @NestedConfigurationProperty
        private final Jsp jsp = new Jsp();
        @NestedConfigurationProperty
        private final Session session = new Session();

        public @Nullable String getContextPath() {
            return this.contextPath;
        }

        public void setContextPath(@Nullable String contextPath) {
            this.contextPath = this.cleanContextPath(contextPath);
        }

        private @Nullable String cleanContextPath(@Nullable String contextPath) {
            String candidate = null;
            if (StringUtils.hasLength((String)contextPath)) {
                candidate = contextPath.strip();
            }
            if (StringUtils.hasText(candidate) && candidate.endsWith("/")) {
                return candidate.substring(0, candidate.length() - 1);
            }
            return candidate;
        }

        public String getApplicationDisplayName() {
            return this.applicationDisplayName;
        }

        public void setApplicationDisplayName(String displayName) {
            this.applicationDisplayName = displayName;
        }

        public boolean isRegisterDefaultServlet() {
            return this.registerDefaultServlet;
        }

        public void setRegisterDefaultServlet(boolean registerDefaultServlet) {
            this.registerDefaultServlet = registerDefaultServlet;
        }

        public Map<String, String> getContextParameters() {
            return this.contextParameters;
        }

        public Encoding getEncoding() {
            return this.encoding;
        }

        public Jsp getJsp() {
            return this.jsp;
        }

        public Session getSession() {
            return this.session;
        }
    }

    public static class Reactive {
        private final Session session = new Session();

        public Session getSession() {
            return this.session;
        }

        public static class Session {
            @DurationUnit(value=ChronoUnit.SECONDS)
            private Duration timeout = Duration.ofMinutes(30L);
            private int maxSessions = 10000;
            @NestedConfigurationProperty
            private final Cookie cookie = new Cookie();

            public Duration getTimeout() {
                return this.timeout;
            }

            public void setTimeout(Duration timeout) {
                this.timeout = timeout;
            }

            public int getMaxSessions() {
                return this.maxSessions;
            }

            public void setMaxSessions(int maxSessions) {
                this.maxSessions = maxSessions;
            }

            public Cookie getCookie() {
                return this.cookie;
            }
        }
    }

    public static enum ForwardHeadersStrategy {
        NATIVE,
        FRAMEWORK,
        NONE;

    }

    public static class Encoding {
        private @Nullable Map<Locale, Charset> mapping;

        public @Nullable Map<Locale, Charset> getMapping() {
            return this.mapping;
        }

        public void setMapping(@Nullable Map<Locale, Charset> mapping) {
            this.mapping = mapping;
        }
    }
}

