/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.slf4j.ILoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class LogUtils {
    LogUtils() {
    }

    public static void setLogLevel(Level level) {
        LogUtils.setLogLevel("ROOT", level);
    }

    private static void setLogLevel(String loggerName, Level level) {
        Logger logger = LogUtils.getLogger(loggerName);
        if (logger != null) {
            logger.setLevel(level);
        }
    }

    private static Logger getLogger(String name) {
        LoggerContext factory = LogUtils.getLoggerContext();
        if (StringUtils.isEmpty((Object)name)) {
            name = "ROOT";
        }
        return factory.getLogger(name);
    }

    private static LoggerContext getLoggerContext() {
        ILoggerFactory factory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        Assert.isInstanceOf(LoggerContext.class, (Object)factory, (String)String.format("LoggerFactory is not a Logback LoggerContext but Logback is on the classpath. Either remove Logback or the competing implementation (%s loaded from %s). If you are using WebLogic you will need to add 'org.slf4j' to prefer-application-packages in WEB-INF/weblogic.xml", factory.getClass(), LogUtils.getLocation(factory)));
        return (LoggerContext)factory;
    }

    private static Object getLocation(ILoggerFactory factory) {
        try {
            ProtectionDomain protectionDomain = factory.getClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource != null) {
                return codeSource.getLocation();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return "unknown location";
    }
}

