/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.zhipuai.api.ApiUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class ZhiPuAiImageApi {
    public static final String DEFAULT_IMAGE_MODEL = ImageModel.CogView_3.getValue();
    private final RestClient restClient;

    public ZhiPuAiImageApi(String zhiPuAiToken) {
        this("https://open.bigmodel.cn/api/paas", zhiPuAiToken, RestClient.builder());
    }

    public ZhiPuAiImageApi(String baseUrl, String zhiPuAiToken, RestClient.Builder restClientBuilder) {
        this(baseUrl, zhiPuAiToken, restClientBuilder, RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public ZhiPuAiImageApi(String baseUrl, String zhiPuAiToken, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(zhiPuAiToken)).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<ZhiPuAiImageResponse> createImage(ZhiPuAiImageRequest zhiPuAiImageRequest) {
        Assert.notNull((Object)zhiPuAiImageRequest, (String)"Image request cannot be null.");
        Assert.hasLength((String)zhiPuAiImageRequest.prompt(), (String)"Prompt cannot be empty.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v4/images/generations", new Object[0])).body((Object)zhiPuAiImageRequest).retrieve().toEntity(ZhiPuAiImageResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ZhiPuAiImageRequest(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="model") String model, @JsonProperty(value="user_id") String user) {
        public ZhiPuAiImageRequest(String prompt, String model) {
            this(prompt, model, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ZhiPuAiImageResponse(@JsonProperty(value="created") Long created, @JsonProperty(value="data") List<Data> data) {
    }

    public static enum ImageModel {
        CogView_3("cogview-3");

        private final String value;

        private ImageModel(String model) {
            this.value = model;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Data(@JsonProperty(value="url") String url) {
    }
}

