/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.zhipuai.ZhiPuAiEmbeddingOptions;
import org.springframework.ai.zhipuai.api.ZhiPuAiApi;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class ZhiPuAiEmbeddingModel
extends AbstractEmbeddingModel {
    private static final Logger logger = LoggerFactory.getLogger(ZhiPuAiEmbeddingModel.class);
    private final ZhiPuAiEmbeddingOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final ZhiPuAiApi zhiPuAiApi;
    private final MetadataMode metadataMode;

    public ZhiPuAiEmbeddingModel(ZhiPuAiApi zhiPuAiApi) {
        this(zhiPuAiApi, MetadataMode.EMBED);
    }

    public ZhiPuAiEmbeddingModel(ZhiPuAiApi zhiPuAiApi, MetadataMode metadataMode) {
        this(zhiPuAiApi, metadataMode, ZhiPuAiEmbeddingOptions.builder().withModel(ZhiPuAiApi.DEFAULT_EMBEDDING_MODEL).build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public ZhiPuAiEmbeddingModel(ZhiPuAiApi zhiPuAiApi, MetadataMode metadataMode, ZhiPuAiEmbeddingOptions zhiPuAiEmbeddingOptions) {
        this(zhiPuAiApi, metadataMode, zhiPuAiEmbeddingOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public ZhiPuAiEmbeddingModel(ZhiPuAiApi zhiPuAiApi, MetadataMode metadataMode, ZhiPuAiEmbeddingOptions options, RetryTemplate retryTemplate) {
        Assert.notNull((Object)zhiPuAiApi, (String)"ZhiPuAiApi must not be null");
        Assert.notNull((Object)metadataMode, (String)"metadataMode must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        this.zhiPuAiApi = zhiPuAiApi;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
    }

    public List<Double> embed(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        return this.embed(document.getFormattedContent(this.metadataMode));
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        return (EmbeddingResponse)this.retryTemplate.execute(ctx -> {
            Assert.notEmpty((Collection)request.getInstructions(), (String)"At least one text is required!");
            if (request.getInstructions().size() != 1) {
                logger.warn("ZhiPu Embedding does not support batch embedding. Will make multiple API calls to embed(Document)");
            }
            ArrayList embeddingList = new ArrayList();
            for (String inputContent : request.getInstructions()) {
                ZhiPuAiApi.EmbeddingRequest<String> apiRequest = this.createZhiPuEmbeddingRequest(inputContent, request.getOptions());
                ZhiPuAiApi.EmbeddingList response = (ZhiPuAiApi.EmbeddingList)this.zhiPuAiApi.embeddings(apiRequest).getBody();
                if (response == null || response.data() == null || response.data().isEmpty()) {
                    logger.warn("No embeddings returned for input: {}", (Object)inputContent);
                    embeddingList.add(List.of());
                    continue;
                }
                embeddingList.add(((ZhiPuAiApi.Embedding)response.data().get(0)).embedding());
            }
            AtomicInteger indexCounter = new AtomicInteger(0);
            List<Embedding> embeddings = embeddingList.stream().map(e -> new Embedding(e, Integer.valueOf(indexCounter.getAndIncrement()))).toList();
            return new EmbeddingResponse(embeddings);
        });
    }

    private ZhiPuAiApi.EmbeddingRequest<String> createZhiPuEmbeddingRequest(String text, EmbeddingOptions requestOptions) {
        ZhiPuAiApi.EmbeddingRequest<Object> apiRequest;
        ZhiPuAiApi.EmbeddingRequest<Object> embeddingRequest = apiRequest = this.defaultOptions != null ? new ZhiPuAiApi.EmbeddingRequest(text, this.defaultOptions.getModel()) : new ZhiPuAiApi.EmbeddingRequest<String>(text, ZhiPuAiApi.DEFAULT_EMBEDDING_MODEL);
        if (requestOptions != null && !EmbeddingOptions.EMPTY.equals(requestOptions)) {
            apiRequest = (ZhiPuAiApi.EmbeddingRequest<Object>)ModelOptionsUtils.merge((Object)requestOptions, apiRequest, ZhiPuAiApi.EmbeddingRequest.class);
        }
        return apiRequest;
    }
}

