/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.api.ResponseFormat;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenAiChatOptions
implements FunctionCallingOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    @JsonProperty(value="logprobs")
    private Boolean logprobs;
    @JsonProperty(value="top_logprobs")
    private Integer topLogprobs;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="max_completion_tokens")
    private Integer maxCompletionTokens;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="modalities")
    private List<String> outputModalities;
    @JsonProperty(value="audio")
    private OpenAiApi.ChatCompletionRequest.AudioParameters outputAudio;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="response_format")
    private ResponseFormat responseFormat;
    @JsonProperty(value="stream_options")
    private OpenAiApi.ChatCompletionRequest.StreamOptions streamOptions;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="tools")
    private List<OpenAiApi.FunctionTool> tools;
    @JsonProperty(value="tool_choice")
    private Object toolChoice;
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="parallel_tool_calls")
    private Boolean parallelToolCalls;
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();
    @JsonIgnore
    private Boolean proxyToolCalls;
    @JsonIgnore
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    @JsonIgnore
    private Map<String, Object> toolContext;

    public static Builder builder() {
        return new Builder();
    }

    public static OpenAiChatOptions fromOptions(OpenAiChatOptions fromOptions) {
        return OpenAiChatOptions.builder().model(fromOptions.getModel()).frequencyPenalty(fromOptions.getFrequencyPenalty()).logitBias(fromOptions.getLogitBias()).logprobs(fromOptions.getLogprobs()).topLogprobs(fromOptions.getTopLogprobs()).maxTokens(fromOptions.getMaxTokens()).maxCompletionTokens(fromOptions.getMaxCompletionTokens()).N(fromOptions.getN()).outputModalities(fromOptions.getOutputModalities()).outputAudio(fromOptions.getOutputAudio()).presencePenalty(fromOptions.getPresencePenalty()).responseFormat(fromOptions.getResponseFormat()).streamUsage(fromOptions.getStreamUsage()).seed(fromOptions.getSeed()).stop(fromOptions.getStop()).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).tools(fromOptions.getTools()).toolChoice(fromOptions.getToolChoice()).user(fromOptions.getUser()).parallelToolCalls(fromOptions.getParallelToolCalls()).functionCallbacks(fromOptions.getFunctionCallbacks()).functions(fromOptions.getFunctions()).httpHeaders(fromOptions.getHttpHeaders()).proxyToolCalls(fromOptions.getProxyToolCalls()).toolContext(fromOptions.getToolContext()).build();
    }

    public Boolean getStreamUsage() {
        return this.streamOptions != null;
    }

    public void setStreamUsage(Boolean enableStreamUsage) {
        this.streamOptions = enableStreamUsage != false ? OpenAiApi.ChatCompletionRequest.StreamOptions.INCLUDE_USAGE : null;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public void setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public List<String> getOutputModalities() {
        return this.outputModalities;
    }

    public void setOutputModalities(List<String> modalities) {
        this.outputModalities = modalities;
    }

    public OpenAiApi.ChatCompletionRequest.AudioParameters getOutputAudio() {
        return this.outputAudio;
    }

    public void setOutputAudio(OpenAiApi.ChatCompletionRequest.AudioParameters audio) {
        this.outputAudio = audio;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public OpenAiApi.ChatCompletionRequest.StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public void setStreamOptions(OpenAiApi.ChatCompletionRequest.StreamOptions streamOptions) {
        this.streamOptions = streamOptions;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public List<OpenAiApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<OpenAiApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    public Boolean getProxyToolCalls() {
        return this.proxyToolCalls;
    }

    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public void setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functionNames) {
        this.functions = functionNames;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public OpenAiChatOptions copy() {
        return OpenAiChatOptions.fromOptions(this);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.maxCompletionTokens, this.n, this.presencePenalty, this.responseFormat, this.streamOptions, this.seed, this.stop, this.temperature, this.topP, this.tools, this.toolChoice, this.user, this.parallelToolCalls, this.functionCallbacks, this.functions, this.httpHeaders, this.proxyToolCalls, this.toolContext, this.outputModalities, this.outputAudio);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenAiChatOptions other = (OpenAiChatOptions)o;
        return Objects.equals(this.model, other.model) && Objects.equals(this.frequencyPenalty, other.frequencyPenalty) && Objects.equals(this.logitBias, other.logitBias) && Objects.equals(this.logprobs, other.logprobs) && Objects.equals(this.topLogprobs, other.topLogprobs) && Objects.equals(this.maxTokens, other.maxTokens) && Objects.equals(this.maxCompletionTokens, other.maxCompletionTokens) && Objects.equals(this.n, other.n) && Objects.equals(this.presencePenalty, other.presencePenalty) && Objects.equals(this.responseFormat, other.responseFormat) && Objects.equals(this.streamOptions, other.streamOptions) && Objects.equals(this.seed, other.seed) && Objects.equals(this.stop, other.stop) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.topP, other.topP) && Objects.equals(this.tools, other.tools) && Objects.equals(this.toolChoice, other.toolChoice) && Objects.equals(this.user, other.user) && Objects.equals(this.parallelToolCalls, other.parallelToolCalls) && Objects.equals(this.functionCallbacks, other.functionCallbacks) && Objects.equals(this.functions, other.functions) && Objects.equals(this.httpHeaders, other.httpHeaders) && Objects.equals(this.toolContext, other.toolContext) && Objects.equals(this.proxyToolCalls, other.proxyToolCalls) && Objects.equals(this.outputModalities, other.outputModalities) && Objects.equals(this.outputAudio, other.outputAudio);
    }

    public String toString() {
        return "OpenAiChatOptions: " + ModelOptionsUtils.toJsonString((Object)this);
    }

    public static class Builder {
        protected OpenAiChatOptions options;

        public Builder() {
            this.options = new OpenAiChatOptions();
        }

        public Builder(OpenAiChatOptions options) {
            this.options = options;
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder model(OpenAiApi.ChatModel openAiChatModel) {
            this.options.model = openAiChatModel.getName();
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.options.logitBias = logitBias;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.options.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.options.topLogprobs = topLogprobs;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder maxCompletionTokens(Integer maxCompletionTokens) {
            this.options.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        public Builder N(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder outputModalities(List<String> modalities) {
            this.options.outputModalities = modalities;
            return this;
        }

        public Builder outputAudio(OpenAiApi.ChatCompletionRequest.AudioParameters audio) {
            this.options.outputAudio = audio;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder streamUsage(boolean enableStreamUsage) {
            this.options.streamOptions = enableStreamUsage ? OpenAiApi.ChatCompletionRequest.StreamOptions.INCLUDE_USAGE : null;
            return this;
        }

        public Builder seed(Integer seed) {
            this.options.seed = seed;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder tools(List<OpenAiApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder toolChoice(Object toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder user(String user) {
            this.options.user = user;
            return this;
        }

        public Builder parallelToolCalls(Boolean parallelToolCalls) {
            this.options.parallelToolCalls = parallelToolCalls;
            return this;
        }

        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder functions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public Builder function(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public Builder proxyToolCalls(Boolean proxyToolCalls) {
            this.options.proxyToolCalls = proxyToolCalls;
            return this;
        }

        public Builder httpHeaders(Map<String, String> httpHeaders) {
            this.options.httpHeaders = httpHeaders;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(String model) {
            this.options.model = model;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(OpenAiApi.ChatModel openAiChatModel) {
            this.options.model = openAiChatModel.getName();
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFrequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withLogitBias(Map<String, Integer> logitBias) {
            this.options.logitBias = logitBias;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withLogprobs(Boolean logprobs) {
            this.options.logprobs = logprobs;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTopLogprobs(Integer topLogprobs) {
            this.options.topLogprobs = topLogprobs;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMaxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMaxCompletionTokens(Integer maxCompletionTokens) {
            this.options.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withN(Integer n) {
            this.options.n = n;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withOutputModalities(List<String> modalities) {
            this.options.outputModalities = modalities;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withOutputAudio(OpenAiApi.ChatCompletionRequest.AudioParameters audio) {
            this.options.outputAudio = audio;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withPresencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withResponseFormat(ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withStreamUsage(boolean enableStreamUsage) {
            this.options.streamOptions = enableStreamUsage ? OpenAiApi.ChatCompletionRequest.StreamOptions.INCLUDE_USAGE : null;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withSeed(Integer seed) {
            this.options.seed = seed;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withStop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTemperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTopP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTools(List<OpenAiApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withToolChoice(Object toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withUser(String user) {
            this.options.user = user;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withParallelToolCalls(Boolean parallelToolCalls) {
            this.options.parallelToolCalls = parallelToolCalls;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunctions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunction(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withProxyToolCalls(Boolean proxyToolCalls) {
            this.options.proxyToolCalls = proxyToolCalls;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withHttpHeaders(Map<String, String> httpHeaders) {
            this.options.httpHeaders = httpHeaders;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withToolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public OpenAiChatOptions build() {
            return this.options;
        }
    }
}

