/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.image.Image;
import org.springframework.ai.image.ImageGeneration;
import org.springframework.ai.image.ImageGenerationMetadata;
import org.springframework.ai.image.ImageMessage;
import org.springframework.ai.image.ImageModel;
import org.springframework.ai.image.ImageOptions;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.ImageResponse;
import org.springframework.ai.image.ImageResponseMetadata;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.openai.OpenAiImageOptions;
import org.springframework.ai.openai.api.OpenAiImageApi;
import org.springframework.ai.openai.metadata.OpenAiImageGenerationMetadata;
import org.springframework.ai.openai.metadata.OpenAiImageResponseMetadata;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class OpenAiImageModel
implements ImageModel {
    private static final Logger logger = LoggerFactory.getLogger(OpenAiImageModel.class);
    private OpenAiImageOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final OpenAiImageApi openAiImageApi;

    public OpenAiImageModel(OpenAiImageApi openAiImageApi) {
        this(openAiImageApi, OpenAiImageOptions.builder().build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public OpenAiImageModel(OpenAiImageApi openAiImageApi, OpenAiImageOptions options, RetryTemplate retryTemplate) {
        Assert.notNull((Object)openAiImageApi, (String)"OpenAiImageApi must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        this.openAiImageApi = openAiImageApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
    }

    public ImageResponse call(ImagePrompt imagePrompt) {
        return (ImageResponse)this.retryTemplate.execute(ctx -> {
            String instructions = ((ImageMessage)imagePrompt.getInstructions().get(0)).getText();
            OpenAiImageApi.OpenAiImageRequest imageRequest = new OpenAiImageApi.OpenAiImageRequest(instructions, OpenAiImageApi.DEFAULT_IMAGE_MODEL);
            if (this.defaultOptions != null) {
                imageRequest = (OpenAiImageApi.OpenAiImageRequest)ModelOptionsUtils.merge((Object)this.defaultOptions, (Object)imageRequest, OpenAiImageApi.OpenAiImageRequest.class);
            }
            if (imagePrompt.getOptions() != null) {
                imageRequest = (OpenAiImageApi.OpenAiImageRequest)ModelOptionsUtils.merge((Object)this.toOpenAiImageOptions(imagePrompt.getOptions()), (Object)imageRequest, OpenAiImageApi.OpenAiImageRequest.class);
            }
            ResponseEntity<OpenAiImageApi.OpenAiImageResponse> imageResponseEntity = this.openAiImageApi.createImage(imageRequest);
            return this.convertResponse(imageResponseEntity, imageRequest);
        });
    }

    private ImageResponse convertResponse(ResponseEntity<OpenAiImageApi.OpenAiImageResponse> imageResponseEntity, OpenAiImageApi.OpenAiImageRequest openAiImageRequest) {
        OpenAiImageApi.OpenAiImageResponse imageApiResponse = (OpenAiImageApi.OpenAiImageResponse)imageResponseEntity.getBody();
        if (imageApiResponse == null) {
            logger.warn("No image response returned for request: {}", (Object)openAiImageRequest);
            return new ImageResponse(List.of());
        }
        List<ImageGeneration> imageGenerationList = imageApiResponse.data().stream().map(entry -> new ImageGeneration(new Image(entry.url(), entry.b64Json()), (ImageGenerationMetadata)new OpenAiImageGenerationMetadata(entry.revisedPrompt()))).toList();
        OpenAiImageResponseMetadata openAiImageResponseMetadata = OpenAiImageResponseMetadata.from(imageApiResponse);
        return new ImageResponse(imageGenerationList, (ImageResponseMetadata)openAiImageResponseMetadata);
    }

    private OpenAiImageOptions toOpenAiImageOptions(ImageOptions runtimeImageOptions) {
        OpenAiImageOptions.Builder openAiImageOptionsBuilder = OpenAiImageOptions.builder();
        if (runtimeImageOptions != null) {
            if (runtimeImageOptions.getN() != null) {
                openAiImageOptionsBuilder.withN(runtimeImageOptions.getN());
            }
            if (runtimeImageOptions.getModel() != null) {
                openAiImageOptionsBuilder.withModel(runtimeImageOptions.getModel());
            }
            if (runtimeImageOptions.getResponseFormat() != null) {
                openAiImageOptionsBuilder.withResponseFormat(runtimeImageOptions.getResponseFormat());
            }
            if (runtimeImageOptions.getWidth() != null) {
                openAiImageOptionsBuilder.withWidth(runtimeImageOptions.getWidth());
            }
            if (runtimeImageOptions.getHeight() != null) {
                openAiImageOptionsBuilder.withHeight(runtimeImageOptions.getHeight());
            }
            if (runtimeImageOptions instanceof OpenAiImageOptions) {
                OpenAiImageOptions runtimeOpenAiImageOptions = (OpenAiImageOptions)runtimeImageOptions;
                if (runtimeOpenAiImageOptions.getQuality() != null) {
                    openAiImageOptionsBuilder.withQuality(runtimeOpenAiImageOptions.getQuality());
                }
                if (runtimeOpenAiImageOptions.getStyle() != null) {
                    openAiImageOptionsBuilder.withStyle(runtimeOpenAiImageOptions.getStyle());
                }
                if (runtimeOpenAiImageOptions.getUser() != null) {
                    openAiImageOptionsBuilder.withUser(runtimeOpenAiImageOptions.getUser());
                }
            }
        }
        return openAiImageOptionsBuilder.build();
    }
}

