/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.RateLimit;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.AbstractFunctionCallSupport;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.openai.OpenAiChatOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.metadata.OpenAiChatResponseMetadata;
import org.springframework.ai.openai.metadata.support.OpenAiResponseHeaderExtractor;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;

public class OpenAiChatModel
extends AbstractFunctionCallSupport<OpenAiApi.ChatCompletionMessage, OpenAiApi.ChatCompletionRequest, ResponseEntity<OpenAiApi.ChatCompletion>>
implements ChatModel,
StreamingChatModel {
    private static final Logger logger = LoggerFactory.getLogger(OpenAiChatModel.class);
    private OpenAiChatOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final OpenAiApi openAiApi;

    public OpenAiChatModel(OpenAiApi openAiApi) {
        this(openAiApi, OpenAiChatOptions.builder().withModel(OpenAiApi.DEFAULT_CHAT_MODEL).withTemperature(Float.valueOf(0.7f)).build());
    }

    public OpenAiChatModel(OpenAiApi openAiApi, OpenAiChatOptions options) {
        this(openAiApi, options, null, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public OpenAiChatModel(OpenAiApi openAiApi, OpenAiChatOptions options, FunctionCallbackContext functionCallbackContext, RetryTemplate retryTemplate) {
        super(functionCallbackContext);
        Assert.notNull((Object)openAiApi, (String)"OpenAiApi must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        this.openAiApi = openAiApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
    }

    public ChatResponse call(Prompt prompt) {
        OpenAiApi.ChatCompletionRequest request = this.createRequest(prompt, false);
        return (ChatResponse)this.retryTemplate.execute(ctx -> {
            ResponseEntity completionEntity = (ResponseEntity)this.callWithFunctionSupport(request);
            OpenAiApi.ChatCompletion chatCompletion = (OpenAiApi.ChatCompletion)completionEntity.getBody();
            if (chatCompletion == null) {
                logger.warn("No chat completion returned for prompt: {}", (Object)prompt);
                return new ChatResponse(List.of());
            }
            RateLimit rateLimits = OpenAiResponseHeaderExtractor.extractAiResponseHeaders(completionEntity);
            List<OpenAiApi.ChatCompletion.Choice> choices = chatCompletion.choices();
            if (choices == null) {
                logger.warn("No choices returned for prompt: {}", (Object)prompt);
                return new ChatResponse(List.of());
            }
            List<Generation> generations = choices.stream().map(choice -> new Generation(choice.message().content(), this.toMap(chatCompletion.id(), (OpenAiApi.ChatCompletion.Choice)choice)).withGenerationMetadata(ChatGenerationMetadata.from((String)choice.finishReason().name(), null))).toList();
            return new ChatResponse(generations, (ChatResponseMetadata)OpenAiChatResponseMetadata.from((OpenAiApi.ChatCompletion)completionEntity.getBody()).withRateLimit(rateLimits));
        });
    }

    private Map<String, Object> toMap(String id, OpenAiApi.ChatCompletion.Choice choice) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        OpenAiApi.ChatCompletionMessage message = choice.message();
        if (message.role() != null) {
            map.put("role", message.role().name());
        }
        if (choice.finishReason() != null) {
            map.put("finishReason", choice.finishReason().name());
        }
        map.put("id", id);
        return map;
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        OpenAiApi.ChatCompletionRequest request = this.createRequest(prompt, true);
        return (Flux)this.retryTemplate.execute(ctx -> {
            Flux<OpenAiApi.ChatCompletionChunk> completionChunks = this.openAiApi.chatCompletionStream(request);
            ConcurrentHashMap roleMap = new ConcurrentHashMap();
            return completionChunks.map(chunk -> this.chunkToChatCompletion((OpenAiApi.ChatCompletionChunk)chunk)).switchMap(cc -> this.handleFunctionCallOrReturnStream(request, Flux.just((Object)ResponseEntity.of(Optional.of(cc))))).map(HttpEntity::getBody).map(chatCompletion -> {
                try {
                    String id = chatCompletion.id();
                    List<Generation> generations = chatCompletion.choices().stream().map(choice -> {
                        if (choice.message().role() != null) {
                            roleMap.putIfAbsent(id, choice.message().role().name());
                        }
                        String finish = choice.finishReason() != null ? choice.finishReason().name() : "";
                        Generation generation = new Generation(choice.message().content(), Map.of("id", id, "role", roleMap.get(id), "finishReason", finish));
                        if (choice.finishReason() != null) {
                            generation = generation.withGenerationMetadata(ChatGenerationMetadata.from((String)choice.finishReason().name(), null));
                        }
                        return generation;
                    }).toList();
                    return new ChatResponse(generations);
                }
                catch (Exception e) {
                    logger.error("Error processing chat completion", (Throwable)e);
                    return new ChatResponse(List.of());
                }
            });
        });
    }

    private OpenAiApi.ChatCompletion chunkToChatCompletion(OpenAiApi.ChatCompletionChunk chunk) {
        List<OpenAiApi.ChatCompletion.Choice> choices = chunk.choices().stream().map(cc -> new OpenAiApi.ChatCompletion.Choice(cc.finishReason(), cc.index(), cc.delta(), cc.logprobs())).toList();
        return new OpenAiApi.ChatCompletion(chunk.id(), choices, chunk.created(), chunk.model(), chunk.systemFingerprint(), "chat.completion", null);
    }

    OpenAiApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        HashSet<String> functionsForThisRequest = new HashSet<String>();
        List<OpenAiApi.ChatCompletionMessage> chatCompletionMessages = prompt.getInstructions().stream().map(m -> {
            ArrayList<OpenAiApi.ChatCompletionMessage.MediaContent> contents = new ArrayList<OpenAiApi.ChatCompletionMessage.MediaContent>(List.of(new OpenAiApi.ChatCompletionMessage.MediaContent(m.getContent())));
            if (!CollectionUtils.isEmpty((Collection)m.getMedia())) {
                contents.addAll(m.getMedia().stream().map(media -> new OpenAiApi.ChatCompletionMessage.MediaContent(new OpenAiApi.ChatCompletionMessage.MediaContent.ImageUrl(this.fromMediaData(media.getMimeType(), media.getData())))).toList());
            }
            return new OpenAiApi.ChatCompletionMessage(contents, OpenAiApi.ChatCompletionMessage.Role.valueOf(m.getMessageType().name()));
        }).toList();
        OpenAiApi.ChatCompletionRequest request = new OpenAiApi.ChatCompletionRequest(chatCompletionMessages, stream);
        if (prompt.getOptions() != null) {
            ModelOptions modelOptions = prompt.getOptions();
            if (modelOptions instanceof ChatOptions) {
                ChatOptions runtimeOptions = (ChatOptions)modelOptions;
                OpenAiChatOptions updatedRuntimeOptions = (OpenAiChatOptions)ModelOptionsUtils.copyToTarget((Object)runtimeOptions, ChatOptions.class, OpenAiChatOptions.class);
                Set promptEnabledFunctions = this.handleFunctionCallbackConfigurations(updatedRuntimeOptions, true);
                functionsForThisRequest.addAll(promptEnabledFunctions);
                request = (OpenAiApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, OpenAiApi.ChatCompletionRequest.class);
            } else {
                throw new IllegalArgumentException("Prompt options are not of type ChatOptions: " + prompt.getOptions().getClass().getSimpleName());
            }
        }
        if (this.defaultOptions != null) {
            Set defaultEnabledFunctions = this.handleFunctionCallbackConfigurations(this.defaultOptions, false);
            functionsForThisRequest.addAll(defaultEnabledFunctions);
            request = (OpenAiApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, OpenAiApi.ChatCompletionRequest.class);
        }
        if (!CollectionUtils.isEmpty(functionsForThisRequest)) {
            request = (OpenAiApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)OpenAiChatOptions.builder().withTools(this.getFunctionTools(functionsForThisRequest)).build(), (Object)request, OpenAiApi.ChatCompletionRequest.class);
        }
        return request;
    }

    private String fromMediaData(MimeType mimeType, Object mediaContentData) {
        if (mediaContentData instanceof byte[]) {
            byte[] bytes = (byte[])mediaContentData;
            return String.format("data:%s;base64,%s", mimeType.toString(), Base64.getEncoder().encodeToString(bytes));
        }
        if (mediaContentData instanceof String) {
            String text = (String)mediaContentData;
            return text;
        }
        throw new IllegalArgumentException("Unsupported media data type: " + mediaContentData.getClass().getSimpleName());
    }

    private List<OpenAiApi.FunctionTool> getFunctionTools(Set<String> functionNames) {
        return this.resolveFunctionCallbacks(functionNames).stream().map(functionCallback -> {
            OpenAiApi.FunctionTool.Function function = new OpenAiApi.FunctionTool.Function(functionCallback.getDescription(), functionCallback.getName(), functionCallback.getInputTypeSchema());
            return new OpenAiApi.FunctionTool(function);
        }).toList();
    }

    protected OpenAiApi.ChatCompletionRequest doCreateToolResponseRequest(OpenAiApi.ChatCompletionRequest previousRequest, OpenAiApi.ChatCompletionMessage responseMessage, List<OpenAiApi.ChatCompletionMessage> conversationHistory) {
        for (OpenAiApi.ChatCompletionMessage.ToolCall toolCall : responseMessage.toolCalls()) {
            String functionName = toolCall.function().name();
            String functionArguments = toolCall.function().arguments();
            if (!this.functionCallbackRegister.containsKey(functionName)) {
                throw new IllegalStateException("No function callback found for function name: " + functionName);
            }
            String functionResponse = ((FunctionCallback)this.functionCallbackRegister.get(functionName)).call(functionArguments);
            conversationHistory.add(new OpenAiApi.ChatCompletionMessage(functionResponse, OpenAiApi.ChatCompletionMessage.Role.TOOL, functionName, toolCall.id(), null));
        }
        OpenAiApi.ChatCompletionRequest newRequest = new OpenAiApi.ChatCompletionRequest(conversationHistory, previousRequest.stream());
        newRequest = (OpenAiApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)newRequest, (Object)previousRequest, OpenAiApi.ChatCompletionRequest.class);
        return newRequest;
    }

    protected List<OpenAiApi.ChatCompletionMessage> doGetUserMessages(OpenAiApi.ChatCompletionRequest request) {
        return request.messages();
    }

    protected OpenAiApi.ChatCompletionMessage doGetToolResponseMessage(ResponseEntity<OpenAiApi.ChatCompletion> chatCompletion) {
        return ((OpenAiApi.ChatCompletion)chatCompletion.getBody()).choices().iterator().next().message();
    }

    protected ResponseEntity<OpenAiApi.ChatCompletion> doChatCompletion(OpenAiApi.ChatCompletionRequest request) {
        return this.openAiApi.chatCompletionEntity(request);
    }

    protected Flux<ResponseEntity<OpenAiApi.ChatCompletion>> doChatCompletionStream(OpenAiApi.ChatCompletionRequest request) {
        return this.openAiApi.chatCompletionStream(request).map(this::chunkToChatCompletion).map(Optional::ofNullable).map(ResponseEntity::of);
    }

    protected boolean isToolFunctionCall(ResponseEntity<OpenAiApi.ChatCompletion> chatCompletion) {
        OpenAiApi.ChatCompletion body = (OpenAiApi.ChatCompletion)chatCompletion.getBody();
        if (body == null) {
            return false;
        }
        List<OpenAiApi.ChatCompletion.Choice> choices = body.choices();
        if (CollectionUtils.isEmpty(choices)) {
            return false;
        }
        OpenAiApi.ChatCompletion.Choice choice = choices.get(0);
        return !CollectionUtils.isEmpty(choice.message().toolCalls()) && choice.finishReason() == OpenAiApi.ChatCompletionFinishReason.TOOL_CALLS;
    }

    public ChatOptions getDefaultOptions() {
        return OpenAiChatOptions.fromOptions(this.defaultOptions);
    }
}

