/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.RateLimit;
import org.springframework.ai.model.Model;
import org.springframework.ai.model.ModelOptions;
import org.springframework.ai.openai.OpenAiAudioTranscriptionOptions;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.ai.openai.audio.transcription.AudioTranscription;
import org.springframework.ai.openai.audio.transcription.AudioTranscriptionPrompt;
import org.springframework.ai.openai.audio.transcription.AudioTranscriptionResponse;
import org.springframework.ai.openai.metadata.audio.OpenAiAudioTranscriptionResponseMetadata;
import org.springframework.ai.openai.metadata.support.OpenAiResponseHeaderExtractor;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class OpenAiAudioTranscriptionModel
implements Model<AudioTranscriptionPrompt, AudioTranscriptionResponse> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final OpenAiAudioTranscriptionOptions defaultOptions;
    public final RetryTemplate retryTemplate;
    private final OpenAiAudioApi audioApi;

    public OpenAiAudioTranscriptionModel(OpenAiAudioApi audioApi) {
        this(audioApi, OpenAiAudioTranscriptionOptions.builder().withModel(OpenAiAudioApi.WhisperModel.WHISPER_1.getValue()).withResponseFormat(OpenAiAudioApi.TranscriptResponseFormat.JSON).withTemperature(Float.valueOf(0.7f)).build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public OpenAiAudioTranscriptionModel(OpenAiAudioApi audioApi, OpenAiAudioTranscriptionOptions options) {
        this(audioApi, options, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public OpenAiAudioTranscriptionModel(OpenAiAudioApi audioApi, OpenAiAudioTranscriptionOptions options, RetryTemplate retryTemplate) {
        Assert.notNull((Object)audioApi, (String)"OpenAiAudioApi must not be null");
        Assert.notNull((Object)options, (String)"OpenAiTranscriptionOptions must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        this.audioApi = audioApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
    }

    public String call(Resource audioResource) {
        AudioTranscriptionPrompt transcriptionRequest = new AudioTranscriptionPrompt(audioResource);
        return this.call(transcriptionRequest).getResult().getOutput();
    }

    public AudioTranscriptionResponse call(AudioTranscriptionPrompt request) {
        return (AudioTranscriptionResponse)this.retryTemplate.execute(ctx -> {
            Resource audioResource = request.getInstructions();
            OpenAiAudioApi.TranscriptionRequest requestBody = this.createRequestBody(request);
            if (requestBody.responseFormat().isJsonType()) {
                ResponseEntity<OpenAiAudioApi.StructuredResponse> transcriptionEntity = this.audioApi.createTranscription(requestBody, OpenAiAudioApi.StructuredResponse.class);
                OpenAiAudioApi.StructuredResponse transcription = (OpenAiAudioApi.StructuredResponse)transcriptionEntity.getBody();
                if (transcription == null) {
                    this.logger.warn("No transcription returned for request: {}", (Object)audioResource);
                    return new AudioTranscriptionResponse(null);
                }
                AudioTranscription transcript = new AudioTranscription(transcription.text());
                RateLimit rateLimits = OpenAiResponseHeaderExtractor.extractAiResponseHeaders(transcriptionEntity);
                return new AudioTranscriptionResponse(transcript, OpenAiAudioTranscriptionResponseMetadata.from((OpenAiAudioApi.StructuredResponse)transcriptionEntity.getBody()).withRateLimit(rateLimits));
            }
            ResponseEntity<String> transcriptionEntity = this.audioApi.createTranscription(requestBody, String.class);
            String transcription = (String)transcriptionEntity.getBody();
            if (transcription == null) {
                this.logger.warn("No transcription returned for request: {}", (Object)audioResource);
                return new AudioTranscriptionResponse(null);
            }
            AudioTranscription transcript = new AudioTranscription(transcription);
            RateLimit rateLimits = OpenAiResponseHeaderExtractor.extractAiResponseHeaders(transcriptionEntity);
            return new AudioTranscriptionResponse(transcript, OpenAiAudioTranscriptionResponseMetadata.from((String)transcriptionEntity.getBody()).withRateLimit(rateLimits));
        });
    }

    OpenAiAudioApi.TranscriptionRequest createRequestBody(AudioTranscriptionPrompt request) {
        OpenAiAudioTranscriptionOptions options = this.defaultOptions;
        if (request.getOptions() != null) {
            ModelOptions modelOptions = request.getOptions();
            if (modelOptions instanceof OpenAiAudioTranscriptionOptions) {
                OpenAiAudioTranscriptionOptions runtimeOptions = (OpenAiAudioTranscriptionOptions)modelOptions;
                options = this.merge(runtimeOptions, options);
            } else {
                throw new IllegalArgumentException("Prompt options are not of type TranscriptionOptions: " + request.getOptions().getClass().getSimpleName());
            }
        }
        OpenAiAudioApi.TranscriptionRequest audioTranscriptionRequest = OpenAiAudioApi.TranscriptionRequest.builder().withFile(this.toBytes(request.getInstructions())).withResponseFormat(options.getResponseFormat()).withPrompt(options.getPrompt()).withTemperature(options.getTemperature()).withLanguage(options.getLanguage()).withModel(options.getModel()).withGranularityType(options.getGranularityType()).build();
        return audioTranscriptionRequest;
    }

    private byte[] toBytes(Resource resource) {
        try {
            return resource.getInputStream().readAllBytes();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read resource: " + resource, e);
        }
    }

    private OpenAiAudioTranscriptionOptions merge(OpenAiAudioTranscriptionOptions source, OpenAiAudioTranscriptionOptions target) {
        if (source == null) {
            source = new OpenAiAudioTranscriptionOptions();
        }
        OpenAiAudioTranscriptionOptions merged = new OpenAiAudioTranscriptionOptions();
        merged.setLanguage(source.getLanguage() != null ? source.getLanguage() : target.getLanguage());
        merged.setModel(source.getModel() != null ? source.getModel() : target.getModel());
        merged.setPrompt(source.getPrompt() != null ? source.getPrompt() : target.getPrompt());
        merged.setResponseFormat(source.getResponseFormat() != null ? source.getResponseFormat() : target.getResponseFormat());
        merged.setTemperature(source.getTemperature() != null ? source.getTemperature() : target.getTemperature());
        merged.setGranularityType(source.getGranularityType() != null ? source.getGranularityType() : target.getGranularityType());
        return merged;
    }
}

