/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.common.autoconfigure;

import io.modelcontextprotocol.server.McpServerFeatures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.mcp.server.common.autoconfigure.McpServerAutoConfiguration;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerProperties;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;

@AutoConfiguration
@EnableConfigurationProperties(value={McpServerProperties.class})
@Conditional(value={ToolCallbackConverterCondition.class, McpServerAutoConfiguration.NonStatelessServerCondition.class})
public class ToolCallbackConverterAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public List<McpServerFeatures.SyncToolSpecification> syncTools(ObjectProvider<List<ToolCallback>> toolCalls, List<ToolCallback> toolCallbackList, ObjectProvider<List<ToolCallbackProvider>> tcbProviderList, ObjectProvider<ToolCallbackProvider> tcbProviders, McpServerProperties serverProperties) {
        List<ToolCallback> tools = this.aggregateToolCallbacks(toolCalls, toolCallbackList, tcbProviderList, tcbProviders);
        return this.toSyncToolSpecifications(tools, serverProperties);
    }

    private List<McpServerFeatures.SyncToolSpecification> toSyncToolSpecifications(List<ToolCallback> tools, McpServerProperties serverProperties) {
        return tools.stream().collect(Collectors.toMap(tool -> tool.getToolDefinition().name(), tool -> tool, (existing, replacement) -> existing)).values().stream().map(tool -> {
            String toolName = tool.getToolDefinition().name();
            MimeType mimeType = serverProperties.getToolResponseMimeType().containsKey(toolName) ? MimeType.valueOf((String)serverProperties.getToolResponseMimeType().get(toolName)) : null;
            return McpToolUtils.toSyncToolSpecification((ToolCallback)tool, mimeType);
        }).toList();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="ASYNC")
    public List<McpServerFeatures.AsyncToolSpecification> asyncTools(ObjectProvider<List<ToolCallback>> toolCalls, List<ToolCallback> toolCallbacksList, ObjectProvider<List<ToolCallbackProvider>> tcbProviderList, ObjectProvider<ToolCallbackProvider> tcbProviders, McpServerProperties serverProperties) {
        List<ToolCallback> tools = this.aggregateToolCallbacks(toolCalls, toolCallbacksList, tcbProviderList, tcbProviders);
        return this.toAsyncToolSpecification(tools, serverProperties);
    }

    private List<McpServerFeatures.AsyncToolSpecification> toAsyncToolSpecification(List<ToolCallback> tools, McpServerProperties serverProperties) {
        return tools.stream().collect(Collectors.toMap(tool -> tool.getToolDefinition().name(), tool -> tool, (existing, replacement) -> existing)).values().stream().map(tool -> {
            String toolName = tool.getToolDefinition().name();
            MimeType mimeType = serverProperties.getToolResponseMimeType().containsKey(toolName) ? MimeType.valueOf((String)serverProperties.getToolResponseMimeType().get(toolName)) : null;
            return McpToolUtils.toAsyncToolSpecification((ToolCallback)tool, mimeType);
        }).toList();
    }

    private List<ToolCallback> aggregateToolCallbacks(ObjectProvider<List<ToolCallback>> toolCalls, List<ToolCallback> toolCallbackList, ObjectProvider<List<ToolCallbackProvider>> tcbProviderList, ObjectProvider<ToolCallbackProvider> tcbProviders) {
        List<Object> totalToolCallbackProviders = new ArrayList(tcbProviderList.stream().flatMap(Collection::stream).toList());
        totalToolCallbackProviders.addAll(tcbProviders.stream().toList());
        totalToolCallbackProviders = totalToolCallbackProviders.stream().distinct().toList();
        ArrayList<ToolCallback> tools = new ArrayList<ToolCallback>(toolCalls.stream().flatMap(Collection::stream).toList());
        if (!CollectionUtils.isEmpty(toolCallbackList)) {
            tools.addAll(toolCallbackList);
        }
        List<ToolCallback> providerToolCallbacks = totalToolCallbackProviders.stream().map(pr -> List.of(pr.getToolCallbacks())).flatMap(Collection::stream).filter(fc -> fc instanceof ToolCallback).map(fc -> fc).toList();
        tools.addAll(providerToolCallbacks);
        return tools;
    }

    public static class ToolCallbackConverterCondition
    extends AllNestedConditions {
        public ToolCallbackConverterCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"tool-callback-converter"}, havingValue="true", matchIfMissing=true)
        static class ToolCallbackConvertCondition {
            ToolCallbackConvertCondition() {
            }
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
        static class McpServerEnabledCondition {
            McpServerEnabledCondition() {
            }
        }
    }
}

