/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client.common.autoconfigure.configurer;

import io.modelcontextprotocol.client.McpClient;
import java.util.List;
import org.springframework.ai.mcp.customizer.McpSyncClientCustomizer;

public class McpSyncClientConfigurer {
    private List<McpSyncClientCustomizer> customizers;

    public McpSyncClientConfigurer(List<McpSyncClientCustomizer> customizers) {
        this.customizers = customizers;
    }

    public McpClient.SyncSpec configure(String name, McpClient.SyncSpec spec) {
        this.applyCustomizers(name, spec);
        return spec;
    }

    private void applyCustomizers(String name, McpClient.SyncSpec spec) {
        if (this.customizers != null) {
            for (McpSyncClientCustomizer customizer : this.customizers) {
                customizer.customize(name, spec);
            }
        }
    }
}

