/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.oas.models.OpenAPI;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.customizers.SpringDocCustomizers;
import org.springdoc.core.fn.AbstractRouterFunctionVisitor;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.providers.SecurityOAuth2Provider;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public abstract class OpenApiResource
extends AbstractOpenApiResource {
    protected OpenApiResource(String groupName, ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        super(groupName, openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    protected OpenApiResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        super("springdocDefault", openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    public byte[] openapiJson(HttpServletRequest request, String apiDocsUrl, Locale locale) throws JsonProcessingException {
        String serverBaseUrl = this.calculateServerUrl(request, apiDocsUrl, locale);
        OpenAPI openAPI = this.getOpenApi(serverBaseUrl, locale);
        return this.writeJsonValue(openAPI);
    }

    public byte[] openapiYaml(HttpServletRequest request, String apiDocsUrl, Locale locale) throws JsonProcessingException {
        String serverBaseUrl = this.calculateServerUrl(request, apiDocsUrl, locale);
        OpenAPI openAPI = this.getOpenApi(serverBaseUrl, locale);
        return this.writeYamlValue(openAPI);
    }

    protected void getPaths(Map<String, Object> restControllers, Locale locale, OpenAPI openAPI) {
        Optional springWebProviderOptional = this.springDocProviders.getSpringWebProvider();
        springWebProviderOptional.ifPresent(springWebProvider -> {
            Map map = springWebProvider.getHandlerMethods();
            Optional repositoryRestResourceProviderOptional = this.springDocProviders.getRepositoryRestResourceProvider();
            repositoryRestResourceProviderOptional.ifPresent(restResourceProvider -> {
                List operationList = restResourceProvider.getRouterOperations(openAPI, locale);
                this.calculatePath(operationList, locale, openAPI);
                restResourceProvider.customize(openAPI);
                Map mapDataRest = restResourceProvider.getHandlerMethods();
                Map requestMappingMap = restResourceProvider.getBasePathAwareControllerEndpoints();
                Class[] additionalRestClasses = (Class[])requestMappingMap.values().stream().map(AopUtils::getTargetClass).toArray(Class[]::new);
                AbstractOpenApiResource.addRestControllers((Class[])additionalRestClasses);
                map.putAll(mapDataRest);
            });
            Optional actuatorProviderOptional = this.springDocProviders.getActuatorProvider();
            if (actuatorProviderOptional.isPresent() && this.springDocConfigProperties.isShowActuator()) {
                Map actuatorMap = ((ActuatorProvider)actuatorProviderOptional.get()).getMethods();
                List<RequestMappingInfo> globMatchActuators = actuatorMap.keySet().stream().filter(requestMappingInfo -> requestMappingInfo.getPatternValues().stream().anyMatch(patternValues -> patternValues.contains("**"))).toList();
                globMatchActuators.forEach(actuatorMap::remove);
                this.openAPIService.addTag(new HashSet(actuatorMap.values()), ActuatorProvider.getTag());
                map.putAll(actuatorMap);
            }
            this.calculatePath(restControllers, map, locale, openAPI);
        });
        Optional securityOAuth2ProviderOptional = this.springDocProviders.getSpringSecurityOAuth2Provider();
        if (securityOAuth2ProviderOptional.isPresent()) {
            SecurityOAuth2Provider securityOAuth2Provider = (SecurityOAuth2Provider)securityOAuth2ProviderOptional.get();
            Map mapOauth = securityOAuth2Provider.getHandlerMethods();
            Map requestMappingMapSec = securityOAuth2Provider.getFrameworkEndpoints();
            Class[] additionalRestClasses = (Class[])requestMappingMapSec.values().stream().map(AopUtils::getTargetClass).toArray(Class[]::new);
            AbstractOpenApiResource.addRestControllers((Class[])additionalRestClasses);
            this.calculatePath(requestMappingMapSec, mapOauth, locale, openAPI);
        }
        this.springDocProviders.getRouterFunctionProvider().ifPresent(routerFunctions -> routerFunctions.getRouterFunctionPaths().ifPresent(routerBeans -> routerBeans.forEach((beanName, routerFunctionVisitor) -> this.getRouterFunctionPaths((String)beanName, (AbstractRouterFunctionVisitor)routerFunctionVisitor, locale, openAPI))));
    }

    protected void calculatePath(Map<String, Object> restControllers, Map<RequestMappingInfo, HandlerMethod> map, Locale locale, OpenAPI openAPI) {
        TreeMap<RequestMappingInfo, HandlerMethod> methodTreeMap = new TreeMap<RequestMappingInfo, HandlerMethod>(this.byReversedRequestMappingInfos());
        methodTreeMap.putAll(map);
        Optional springWebProviderOptional = this.springDocProviders.getSpringWebProvider();
        springWebProviderOptional.ifPresent(springWebProvider -> {
            for (Map.Entry entry : methodTreeMap.entrySet()) {
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
                HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
                Set patterns = springWebProvider.getActivePatterns((Object)requestMappingInfo);
                if (CollectionUtils.isEmpty((Collection)patterns)) continue;
                LinkedHashMap regexMap = new LinkedHashMap();
                for (String pattern : patterns) {
                    String operationPath = PathUtils.parsePath((String)pattern, regexMap);
                    String[] produces = (String[])requestMappingInfo.getProducesCondition().getProducibleMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                    String[] consumes = (String[])requestMappingInfo.getConsumesCondition().getConsumableMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                    String[] headers = (String[])requestMappingInfo.getHeadersCondition().getExpressions().stream().map(Object::toString).toArray(String[]::new);
                    String[] params = (String[])requestMappingInfo.getParamsCondition().getExpressions().stream().map(Object::toString).toArray(String[]::new);
                    if (!this.isRestController(restControllers, handlerMethod, operationPath) && !this.isActuatorRestController(operationPath, handlerMethod) || !this.isFilterCondition(handlerMethod, operationPath, produces, consumes, headers)) continue;
                    Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
                    if (requestMethods.isEmpty()) {
                        requestMethods = this.getDefaultAllowedHttpMethods();
                    }
                    this.calculatePath(handlerMethod, operationPath, requestMethods, consumes, produces, headers, params, locale, openAPI);
                }
            }
        });
    }

    private Comparator<RequestMappingInfo> byReversedRequestMappingInfos() {
        return (o2, o1) -> o1.toString().compareTo(o2.toString());
    }

    protected String calculateServerUrl(HttpServletRequest request, String apiDocsUrl, Locale locale) {
        super.initOpenAPIBuilder(locale);
        String calculatedUrl = this.getServerUrl(request, apiDocsUrl);
        ServletServerHttpRequest serverRequest = request != null ? new ServletServerHttpRequest(request) : null;
        return this.openAPIService.calculateServerBaseUrl(calculatedUrl, (HttpRequest)serverRequest);
    }

    protected abstract String getServerUrl(HttpServletRequest var1, String var2);
}

