/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.okhttp.internal.http;

import java.io.IOException;
import org.sonar.runner.okhttp.Request;
import org.sonar.runner.okhttp.Response;
import org.sonar.runner.okhttp.ResponseBody;
import org.sonar.runner.okhttp.internal.http.HttpConnection;
import org.sonar.runner.okhttp.internal.http.HttpEngine;
import org.sonar.runner.okhttp.internal.http.OkHeaders;
import org.sonar.runner.okhttp.internal.http.RealResponseBody;
import org.sonar.runner.okhttp.internal.http.RequestLine;
import org.sonar.runner.okhttp.internal.http.RetryableSink;
import org.sonar.runner.okhttp.internal.http.Transport;
import org.sonar.runner.okio.Okio;
import org.sonar.runner.okio.Sink;
import org.sonar.runner.okio.Source;

public final class HttpTransport
implements Transport {
    private final HttpEngine httpEngine;
    private final HttpConnection httpConnection;

    public HttpTransport(HttpEngine httpEngine, HttpConnection httpConnection) {
        this.httpEngine = httpEngine;
        this.httpConnection = httpConnection;
    }

    @Override
    public Sink createRequestBody(Request request, long contentLength) throws IOException {
        if ("chunked".equalsIgnoreCase(request.header("Transfer-Encoding"))) {
            return this.httpConnection.newChunkedSink();
        }
        if (contentLength != -1L) {
            return this.httpConnection.newFixedLengthSink(contentLength);
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public void finishRequest() throws IOException {
        this.httpConnection.flush();
    }

    @Override
    public void writeRequestBody(RetryableSink requestBody) throws IOException {
        this.httpConnection.writeRequestBody(requestBody);
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        this.httpEngine.writingRequestHeaders();
        String requestLine = RequestLine.get(request, this.httpEngine.getConnection().getRoute().getProxy().type());
        this.httpConnection.writeRequest(request.headers(), requestLine);
    }

    @Override
    public Response.Builder readResponseHeaders() throws IOException {
        return this.httpConnection.readResponse();
    }

    @Override
    public void releaseConnectionOnIdle() throws IOException {
        if (this.canReuseConnection()) {
            this.httpConnection.poolOnIdle();
        } else {
            this.httpConnection.closeOnIdle();
        }
    }

    @Override
    public boolean canReuseConnection() {
        if ("close".equalsIgnoreCase(this.httpEngine.getRequest().header("Connection"))) {
            return false;
        }
        if ("close".equalsIgnoreCase(this.httpEngine.getResponse().header("Connection"))) {
            return false;
        }
        return !this.httpConnection.isClosed();
    }

    @Override
    public ResponseBody openResponseBody(Response response) throws IOException {
        Source source = this.getTransferStream(response);
        return new RealResponseBody(response.headers(), Okio.buffer(source));
    }

    private Source getTransferStream(Response response) throws IOException {
        if (!HttpEngine.hasBody(response)) {
            return this.httpConnection.newFixedLengthSource(0L);
        }
        if ("chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) {
            return this.httpConnection.newChunkedSource(this.httpEngine);
        }
        long contentLength = OkHeaders.contentLength(response);
        if (contentLength != -1L) {
            return this.httpConnection.newFixedLengthSource(contentLength);
        }
        return this.httpConnection.newUnknownLengthSource();
    }

    @Override
    public void disconnect(HttpEngine engine) throws IOException {
        this.httpConnection.closeIfOwnedBy(engine);
    }
}

