/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonarsource.scanner.maven.bootstrap.MavenUtils;
import org.sonarsource.scanner.maven.bootstrap.ToolchainResolver;

public class MavenCompilerResolver {
    private static final String DEFAULT_COMPILE_EXECUTION_ID = "default-compile";
    private static final String TEST_COMPILE_PHASE = "test-compile";
    private static final String COMPILE_GOAL = "compile";
    private static final String TEST_COMPILE_GOAL = "testCompile";
    private static final String MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    private final MavenSession session;
    private final Log log;
    private final ToolchainResolver toolchainResolver;
    private final LifecycleExecutor lifecycleExecutor;

    public MavenCompilerResolver(MavenSession session, LifecycleExecutor lifecycleExecutor, Log log, ToolchainResolver toolchainResolver) {
        this.session = session;
        this.lifecycleExecutor = lifecycleExecutor;
        this.log = log;
        this.toolchainResolver = toolchainResolver;
    }

    private static int defaultCompileFirstThenCompileFirst(MojoExecution a, MojoExecution b) {
        if (DEFAULT_COMPILE_EXECUTION_ID.equals(a.getExecutionId())) {
            return -1;
        }
        if (DEFAULT_COMPILE_EXECUTION_ID.equals(b.getExecutionId())) {
            return 1;
        }
        return a.getGoal().compareTo(b.getGoal());
    }

    private static boolean isMavenCompilerGoal(MojoExecution e) {
        return e.getArtifactId().equals(MAVEN_COMPILER_PLUGIN) && e.getGroupId().equals("org.apache.maven.plugins") && (e.getGoal().equals(COMPILE_GOAL) || e.getGoal().equals(TEST_COMPILE_GOAL));
    }

    static Optional<Path> toJdkHomeFromJavacExec(String javacExecutable) {
        Path bin = Path.of(javacExecutable, new String[0]).toAbsolutePath().getParent();
        if ("bin".equals(bin.getFileName().toString())) {
            return Optional.of(bin.getParent());
        }
        return Optional.empty();
    }

    private static Optional<String> getJavacExecutableFromRuntimeJdk() {
        String javacCommand = "javac" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        Path javacExe = SystemUtils.IS_OS_AIX ? Paths.get(javaHome, "..", "sh", javacCommand).normalize() : (SystemUtils.IS_OS_MAC_OSX ? Paths.get(javaHome, "bin", javacCommand) : Paths.get(javaHome, "..", "bin", javacCommand).normalize());
        if (!Files.isRegularFile(javacExe, new LinkOption[0])) {
            Map<String, String> env = System.getenv();
            javaHome = env.get("JAVA_HOME");
            if (StringUtils.isEmpty((CharSequence)javaHome) || !new File(javaHome).isDirectory()) {
                return Optional.empty();
            }
            javacExe = Paths.get(javaHome, "bin", javacCommand);
        }
        if (!Files.isRegularFile(javacExe, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(javacExe.toAbsolutePath().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<MavenCompilerConfiguration> extractConfiguration(MavenProject pom) {
        MavenProject oldProject = this.session.getCurrentProject();
        try {
            this.session.setCurrentProject(pom);
            List allCompilerExecutions = this.lifecycleExecutor.calculateExecutionPlan(this.session, true, new String[]{TEST_COMPILE_PHASE}).getMojoExecutions().stream().filter(MavenCompilerResolver::isMavenCompilerGoal).sorted(MavenCompilerResolver::defaultCompileFirstThenCompileFirst).collect(Collectors.toList());
            if (allCompilerExecutions.isEmpty()) {
                Optional<MavenCompilerConfiguration> optional = Optional.empty();
                return optional;
            }
            List allCompilerConfigurations = allCompilerExecutions.stream().map(this::extractConfiguration).collect(Collectors.toList());
            MavenCompilerConfiguration first = (MavenCompilerConfiguration)allCompilerConfigurations.get(0);
            if (!allCompilerConfigurations.stream().allMatch(config -> MavenCompilerConfiguration.same(config, first))) {
                this.log.warn((CharSequence)("Heterogeneous compiler configuration has been detected. Using compiler configuration from execution: '" + first.getExecutionId() + "'"));
            }
            Optional<MavenCompilerConfiguration> optional = Optional.of(first);
            return optional;
        }
        catch (Exception e) {
            this.log.warn((CharSequence)"Failed to collect configuration from the maven-compiler-plugin", (Throwable)e);
            Optional<MavenCompilerConfiguration> optional = Optional.empty();
            return optional;
        }
        finally {
            this.session.setCurrentProject(oldProject);
        }
    }

    private MavenCompilerConfiguration extractConfiguration(MojoExecution compilerExecution) {
        MavenCompilerConfiguration result = new MavenCompilerConfiguration(compilerExecution.getExecutionId());
        result.release = this.getStringConfiguration(compilerExecution, "release");
        result.target = this.getStringConfiguration(compilerExecution, "target");
        result.source = this.getStringConfiguration(compilerExecution, "source");
        result.enablePreview = this.getStringConfiguration(compilerExecution, "enablePreview");
        result.jdkHome = this.getJdkHome(compilerExecution);
        return result;
    }

    private Optional<String> getStringConfiguration(MojoExecution exec, String parameterName) {
        Xpp3Dom configuration = exec.getConfiguration();
        XmlPlexusConfiguration pomConfiguration = new XmlPlexusConfiguration(configuration);
        PlexusConfiguration config = pomConfiguration.getChild(parameterName, false);
        if (config == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(MavenUtils.convertString(this.session, this.log, exec, config));
    }

    private Optional<Path> getJdkHome(MojoExecution compilerExecution) {
        Optional<String> executable = this.getStringConfiguration(compilerExecution, "executable");
        if (executable.isPresent()) {
            return MavenCompilerResolver.toJdkHomeFromJavacExec(executable.get());
        }
        Optional<Path> jdkHomeFromToolchain = this.toolchainResolver.getJdkHomeFromToolchains(compilerExecution);
        if (jdkHomeFromToolchain.isPresent()) {
            return jdkHomeFromToolchain;
        }
        Optional<String> runtimeCompiler = MavenCompilerResolver.getJavacExecutableFromRuntimeJdk();
        if (runtimeCompiler.isPresent()) {
            return MavenCompilerResolver.toJdkHomeFromJavacExec(runtimeCompiler.get());
        }
        return Optional.empty();
    }

    public static class MavenCompilerConfiguration {
        private final String executionId;
        private Optional<String> release;
        private Optional<String> target;
        private Optional<String> source;
        private Optional<Path> jdkHome;
        private Optional<String> enablePreview;

        private MavenCompilerConfiguration(String executionId) {
            this.executionId = executionId;
        }

        public static boolean same(MavenCompilerConfiguration one, MavenCompilerConfiguration two) {
            return Objects.equals(one.getJdkHome(), two.getJdkHome()) && Objects.equals(one.getRelease(), two.getRelease()) && Objects.equals(one.getSource(), two.getSource()) && Objects.equals(one.getTarget(), two.getTarget()) && Objects.equals(one.getEnablePreview(), two.getEnablePreview());
        }

        public Optional<String> getRelease() {
            return this.release;
        }

        public Optional<String> getTarget() {
            return this.target;
        }

        public Optional<String> getSource() {
            return this.source;
        }

        public Optional<Path> getJdkHome() {
            return this.jdkHome;
        }

        public Optional<String> getEnablePreview() {
            return this.enablePreview;
        }

        public String getExecutionId() {
            return this.executionId;
        }
    }
}

