/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.System2;
import org.sonarsource.scanner.lib.internal.ProcessWrapperFactory;

public class ArchResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ArchResolver.class);
    private final System2 system;
    private final ProcessWrapperFactory processWrapperFactory;
    private final boolean useUname;

    public ArchResolver() {
        this(new System2(), new ProcessWrapperFactory(), SystemUtils.IS_OS_UNIX);
    }

    ArchResolver(System2 system, ProcessWrapperFactory processWrapperFactory, boolean useUname) {
        this.system = system;
        this.processWrapperFactory = processWrapperFactory;
        this.useUname = useUname;
    }

    public String getCpuArch() {
        Optional<String> archFromUname = Optional.empty();
        if (this.useUname) {
            archFromUname = this.tryGetArchUsingUname();
        }
        return archFromUname.orElseGet(() -> this.system.getProperty("os.arch"));
    }

    private Optional<String> tryGetArchUsingUname() {
        try {
            String arch;
            ProcessWrapperFactory.ProcessWrapper process = this.processWrapperFactory.create("uname", "-m");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                arch = reader.lines().findFirst().orElseThrow(() -> new IllegalStateException("No output from 'uname -m'"));
                LOG.debug("uname -m returned '{}'", (Object)arch);
            }
            int exit = process.waitFor();
            if (exit != 0) {
                LOG.debug("Command exited with code: {}", (Object)exit);
                return Optional.empty();
            }
            return Optional.of(arch);
        }
        catch (Exception e) {
            LOG.debug("Failed to get the architecture using 'uname -m'", (Throwable)e);
            return Optional.empty();
        }
    }
}

