/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.previous.core.data.ExecutionDataWriter;
import org.sonar.java.AnalysisException;
import org.sonar.plugins.jacoco.ExecutionDataVisitor;
import org.sonar.plugins.jacoco.JacocoReportReader;

public final class JaCoCoReportMerger {
    private JaCoCoReportMerger() {
    }

    public static void mergeReports(File reportOverall, File ... reports) {
        ExecutionDataVisitor edv = new ExecutionDataVisitor();
        boolean isCurrentVersionFormat = JaCoCoReportMerger.loadSourceFiles(edv, reports);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(reportOverall));){
            Object visitor = isCurrentVersionFormat ? new org.jacoco.core.data.ExecutionDataWriter((OutputStream)outputStream) : new ExecutionDataWriter((OutputStream)outputStream);
            for (Map.Entry<String, ExecutionDataStore> entry : edv.getSessions().entrySet()) {
                SessionInfo sessionInfo = new SessionInfo(entry.getKey(), 0L, 0L);
                ((ISessionInfoVisitor)visitor).visitSessionInfo(sessionInfo);
                entry.getValue().accept((IExecutionDataVisitor)visitor);
            }
        }
        catch (IOException e) {
            throw new AnalysisException(String.format("Unable to write overall coverage report %s", reportOverall.getAbsolutePath()), (Throwable)e);
        }
    }

    private static boolean loadSourceFiles(ExecutionDataVisitor executionDataVisitor, File ... reports) {
        Boolean isCurrentVersionFormat = null;
        for (File report : reports) {
            if (!report.isFile()) continue;
            JacocoReportReader jacocoReportReader = new JacocoReportReader(report).readJacocoReport(executionDataVisitor, executionDataVisitor);
            boolean reportFormatIsCurrent = jacocoReportReader.useCurrentBinaryFormat();
            if (isCurrentVersionFormat == null) {
                isCurrentVersionFormat = reportFormatIsCurrent;
                continue;
            }
            if (isCurrentVersionFormat.equals(reportFormatIsCurrent)) continue;
            throw new IllegalStateException("You are trying to merge two different JaCoCo binary formats. Please use only one version of JaCoCo.");
        }
        return BooleanUtils.isNotFalse(isCurrentVersionFormat);
    }
}

