/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.api.location;

import java.util.Comparator;
import org.sonar.java.model.location.InternalPosition;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

public interface Position
extends Comparable<Position> {
    public static final Comparator<Tree> TREE_START_POSITION_COMPARATOR = (t1, t2) -> Position.startOf(t1).compareTo(Position.startOf(t2));
    public static final int FIRST_LINE = 1;
    public static final int FIRST_COLUMN = 1;

    public int line();

    public int lineOffset();

    public int column();

    public int columnOffset();

    public static Position at(int line, int column) {
        return new InternalPosition(line, column);
    }

    public boolean isBefore(Position var1);

    public boolean isAfter(Position var1);

    public static Position startOf(Tree tree) {
        return Position.startOf(tree.firstToken());
    }

    public static Position endOf(Tree tree) {
        return Position.endOf(tree.lastToken());
    }

    public static Position startOf(SyntaxTrivia trivia) {
        return trivia.range().start();
    }

    public static Position endOf(SyntaxTrivia trivia) {
        return trivia.range().end();
    }

    public static Position startOf(SyntaxToken token) {
        return token.range().start();
    }

    public static Position endOf(SyntaxToken token) {
        return token.range().end();
    }
}

