/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.api;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.rule.RuleKey;
import org.sonar.java.Preconditions;
import org.sonar.java.annotations.Beta;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonarsource.api.sonarlint.SonarLintSide;

@SonarLintSide
@ScannerSide
@Beta
public interface CheckRegistrar {
    public void register(RegistrarContext var1);

    public static class RegistrarContext {
        private String repositoryKey;
        private Iterable<Class<? extends JavaCheck>> mainCheckClassList;
        private Iterable<Class<? extends JavaCheck>> testCheckClassList;

        public void registerClassesForRepository(String repositoryKey, Iterable<Class<? extends JavaCheck>> checkClasses, Iterable<Class<? extends JavaCheck>> testCheckClasses) {
            Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)repositoryKey), "Please specify a valid repository key to register your custom rules");
            this.repositoryKey = repositoryKey;
            this.mainCheckClassList = checkClasses;
            this.testCheckClassList = testCheckClasses;
            this.registerMainChecks(repositoryKey, RegistrarContext.asCollection(checkClasses));
            this.registerTestChecks(repositoryKey, RegistrarContext.asCollection(testCheckClasses));
        }

        @Deprecated(since="7.25", forRemoval=true)
        public String repositoryKey() {
            return this.repositoryKey;
        }

        @Deprecated(since="7.25", forRemoval=true)
        public Iterable<Class<? extends JavaCheck>> checkClasses() {
            return this.mainCheckClassList;
        }

        @Deprecated(since="7.25", forRemoval=true)
        public Iterable<Class<? extends JavaCheck>> testCheckClasses() {
            return this.testCheckClassList;
        }

        public void registerMainChecks(String repositoryKey, Collection<?> javaCheckClassesAndInstances) {
        }

        public void registerTestChecks(String repositoryKey, Collection<?> javaCheckClassesAndInstances) {
        }

        public void registerMainSharedCheck(JavaCheck check, Collection<RuleKey> ruleKeys) {
        }

        public void registerTestSharedCheck(JavaCheck check, Collection<RuleKey> ruleKeys) {
        }

        public void registerAutoScanCompatibleRules(Collection<RuleKey> ruleKeys) {
        }

        private static <T> Collection<T> asCollection(@Nullable Iterable<T> iterable) {
            return iterable != null ? (Collection)StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList()) : Collections.emptyList();
        }
    }
}

