/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.sonar.java.model.JMethodSymbol;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JType;
import org.sonar.java.model.Symbols;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

public final class JUtils {
    static final Map<String, String> WRAPPER_TO_PRIMITIVE = MapBuilder.newMap().put((Object)"java.lang.Byte", (Object)"byte").put((Object)"java.lang.Character", (Object)"char").put((Object)"java.lang.Short", (Object)"short").put((Object)"java.lang.Integer", (Object)"int").put((Object)"java.lang.Long", (Object)"long").put((Object)"java.lang.Float", (Object)"float").put((Object)"java.lang.Double", (Object)"double").put((Object)"java.lang.Boolean", (Object)"boolean").build();
    static final Map<String, String> PRIMITIVE_TO_WRAPPER = MapBuilder.newMap().put((Object)"byte", (Object)"java.lang.Byte").put((Object)"char", (Object)"java.lang.Character").put((Object)"short", (Object)"java.lang.Short").put((Object)"int", (Object)"java.lang.Integer").put((Object)"long", (Object)"java.lang.Long").put((Object)"float", (Object)"java.lang.Float").put((Object)"double", (Object)"java.lang.Double").put((Object)"boolean", (Object)"java.lang.Boolean").build();

    private JUtils() {
    }

    public static Type wrapTypeIfPrimitive(Type type) {
        Type wrapped = type.primitiveWrapperType();
        return Objects.requireNonNullElse(wrapped, type);
    }

    public static boolean isIntersectionType(Type type) {
        return !type.isUnknown() && ((JType)type).typeBinding.isIntersectionType();
    }

    public static void collectSuperTypes(Set<Type> result, JSema sema, ITypeBinding typeBinding) {
        ITypeBinding s = typeBinding.getSuperclass();
        if (s != null) {
            result.add(sema.type(s));
            JUtils.collectSuperTypes(result, sema, s);
        }
        for (ITypeBinding i : typeBinding.getInterfaces()) {
            result.add(sema.type(i));
            JUtils.collectSuperTypes(result, sema, i);
        }
    }

    public static Symbol getPackage(Symbol symbol) {
        while (!symbol.isPackageSymbol()) {
            symbol = symbol.owner();
        }
        return symbol;
    }

    public static boolean isNativeMethod(Symbol.MethodSymbol method) {
        return !method.isUnknown() && Modifier.isNative((int)((JMethodSymbol)method).binding.getModifiers());
    }

    @Nullable
    public static Object defaultValue(Symbol.MethodSymbol method) {
        if (method.isUnknown()) {
            return null;
        }
        return ((JMethodSymbol)method).methodBinding().getDefaultValue();
    }

    public static Set<Type> directSuperTypes(Type type) {
        if (type.isUnknown()) {
            return Collections.emptySet();
        }
        HashSet<Type> result = new HashSet<Type>();
        JType t = (JType)type;
        ITypeBinding superclass = t.typeBinding.getSuperclass();
        if (superclass != null) {
            result.add(t.sema.type(superclass));
        }
        for (ITypeBinding i : t.typeBinding.getInterfaces()) {
            result.add(t.sema.type(i));
        }
        return result;
    }

    @Nullable
    public static Symbol enclosingClass(Tree t) {
        while (t != null) {
            if (t.is(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE)) {
                return ((ClassTree)t).symbol();
            }
            t = t.parent();
        }
        return null;
    }

    public static SymbolMetadata parameterAnnotations(Symbol.MethodSymbol method, int param) {
        if (method.isUnknown()) {
            return Symbols.EMPTY_METADATA;
        }
        return method.declarationParameters().get(param).metadata();
    }

    public static boolean hasUnknownTypePreventingOverrideResolution(Symbol.MethodSymbol symbol) {
        Symbol owner = symbol.owner();
        if (owner == null || !owner.isTypeSymbol()) {
            return true;
        }
        boolean hasUnknownParameterType = symbol.parameterTypes().stream().anyMatch(Type::isUnknown);
        if (hasUnknownParameterType) {
            return JUtils.hasUnknownTypeInHierarchyOrAnyMatchingMethod((Symbol.TypeSymbol)owner, symbol);
        }
        return JUtils.hasUnknownTypeInHierarchy((Symbol.TypeSymbol)owner);
    }

    public static boolean hasUnknownTypeInHierarchy(Symbol.TypeSymbol typeSymbol) {
        if (typeSymbol.isUnknown()) {
            return true;
        }
        if (typeSymbol.interfaces().stream().map(Type::symbol).anyMatch(JUtils::hasUnknownTypeInHierarchy)) {
            return true;
        }
        Type superClass = typeSymbol.superClass();
        if (superClass == null) {
            return false;
        }
        return JUtils.hasUnknownTypeInHierarchy(superClass.symbol());
    }

    private static boolean hasUnknownTypeInHierarchyOrAnyMatchingMethod(Symbol.TypeSymbol typeSymbol, Symbol.MethodSymbol methodSymbol) {
        if (typeSymbol.isUnknown()) {
            return true;
        }
        if (typeSymbol != methodSymbol.owner() && typeSymbol.memberSymbols().stream().anyMatch(member -> member.isMethodSymbol() && ((Symbol.MethodSymbol)member).parameterTypes().size() == methodSymbol.parameterTypes().size() && methodSymbol.name().equals(member.name()))) {
            return true;
        }
        if (typeSymbol.interfaces().stream().map(Type::symbol).anyMatch(interfaceSymbol -> JUtils.hasUnknownTypeInHierarchyOrAnyMatchingMethod(interfaceSymbol, methodSymbol))) {
            return true;
        }
        Type superClass = typeSymbol.superClass();
        if (superClass == null) {
            return false;
        }
        return JUtils.hasUnknownTypeInHierarchyOrAnyMatchingMethod(superClass.symbol(), methodSymbol);
    }
}

