/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.AnalysisProgress;
import org.sonar.java.ExecutionTimeReport;
import org.sonar.java.ProgressMonitor;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.model.JParser;
import org.sonar.java.model.JProblem;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonarsource.analyzer.commons.ProgressReport;
import org.sonarsource.performance.measure.PerformanceMeasure;

public abstract class JParserConfig {
    public static final JavaVersion MAXIMUM_SUPPORTED_JAVA_VERSION = new JavaVersionImpl(19, true);
    private static final Logger LOG = LoggerFactory.getLogger(JParserConfig.class);
    private static final String MAXIMUM_ECJ_WARNINGS = "42000";
    private static final Set<String> JRE_JARS = new HashSet<String>(Arrays.asList("rt.jar", "jrt-fs.jar", "android.jar"));
    final JavaVersion javaVersion;
    final List<File> classpath;
    final boolean shouldIgnoreUnnamedModuleForSplitPackage;

    private JParserConfig(JavaVersion javaVersion, List<File> classpath, boolean shouldIgnoreUnnamedModuleForSplitPackage) {
        this.javaVersion = javaVersion;
        this.classpath = classpath;
        this.shouldIgnoreUnnamedModuleForSplitPackage = shouldIgnoreUnnamedModuleForSplitPackage;
    }

    public abstract void parse(Iterable<? extends InputFile> var1, BooleanSupplier var2, AnalysisProgress var3, BiConsumer<InputFile, Result> var4);

    public ASTParser astParser() {
        ASTParser astParser = ASTParser.newParser((int)AST.getJLSLatest());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.compiler.compliance", this.javaVersion.effectiveJavaVersionAsString());
        options.put("org.eclipse.jdt.core.compiler.source", this.javaVersion.effectiveJavaVersionAsString());
        options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", MAXIMUM_ECJ_WARNINGS);
        if (this.shouldIgnoreUnnamedModuleForSplitPackage) {
            options.put("org.eclipse.jdt.core.compiler.ignoreUnnamedModuleForSplitPackage", "enabled");
        }
        if (JParserConfig.shouldEnablePreviewFlag(this.javaVersion)) {
            options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        }
        JProblem.Type.compilerOptions().forEach(option -> options.put((String)option, "warning"));
        astParser.setCompilerOptions(options);
        boolean includeRunningVMBootclasspath = this.classpath.stream().noneMatch(f -> JRE_JARS.contains(f.getName()));
        astParser.setEnvironment((String[])this.classpath.stream().map(File::getAbsolutePath).toArray(String[]::new), new String[0], new String[0], includeRunningVMBootclasspath);
        astParser.setResolveBindings(true);
        astParser.setBindingsRecovery(true);
        return astParser;
    }

    @VisibleForTesting
    static boolean shouldEnablePreviewFlag(JavaVersion currentVersion) {
        return currentVersion.arePreviewFeaturesEnabled();
    }

    @FunctionalInterface
    public static interface ParserConfigConstructor {
        public JParserConfig apply(JavaVersion var1, List<File> var2, Boolean var3);
    }

    private static class FileByFile
    extends JParserConfig {
        private FileByFile(JavaVersion javaVersion, List<File> classpath, boolean shouldIgnoreUnnamedModuleForSplitPackage) {
            super(javaVersion, classpath, shouldIgnoreUnnamedModuleForSplitPackage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(Iterable<? extends InputFile> inputFiles, BooleanSupplier isCanceled, AnalysisProgress analysisProgress, BiConsumer<InputFile, Result> action) {
            boolean successfullyCompleted = false;
            boolean cancelled = false;
            ExecutionTimeReport executionTimeReport = new ExecutionTimeReport();
            ProgressReport progressReport = new ProgressReport("Report about progress of Java AST analyzer", TimeUnit.SECONDS.toMillis(10L));
            List filesNames = StreamSupport.stream(inputFiles.spliterator(), false).map(InputFile::toString).collect(Collectors.toList());
            progressReport.start(filesNames);
            try {
                for (InputFile inputFile : inputFiles) {
                    if (isCanceled.getAsBoolean()) {
                        cancelled = true;
                        break;
                    }
                    executionTimeReport.start(inputFile);
                    FileByFile.parse(this.astParser(), inputFile, this.javaVersion, action);
                    executionTimeReport.end();
                    progressReport.nextFile();
                }
                successfullyCompleted = !cancelled;
            }
            finally {
                if (successfullyCompleted) {
                    progressReport.stop();
                } else {
                    progressReport.cancel();
                }
                executionTimeReport.report();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void parse(ASTParser astParser, InputFile inputFile, JavaVersion javaVersion, BiConsumer<InputFile, Result> action) {
            Result result;
            PerformanceMeasure.Duration parseDuration = PerformanceMeasure.start((String)"JParser");
            try {
                result = new Result(JParser.parse(astParser, javaVersion.effectiveJavaVersionAsString(), inputFile.filename(), inputFile.contents()));
            }
            catch (Exception e) {
                result = new Result(e);
            }
            finally {
                parseDuration.stop();
            }
            action.accept(inputFile, result);
        }
    }

    @VisibleForTesting
    static class Batch
    extends JParserConfig {
        Batch(JavaVersion javaVersion, List<File> classpath, boolean shouldIgnoreUnnamedModuleForSplitPackage) {
            super(javaVersion, classpath, shouldIgnoreUnnamedModuleForSplitPackage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(Iterable<? extends InputFile> inputFiles, BooleanSupplier isCanceled, AnalysisProgress analysisProgress, final BiConsumer<InputFile, Result> action) {
            ArrayList<String> sourceFilePaths = new ArrayList<String>();
            final HashSet analyzedSourceFilePaths = new HashSet();
            ArrayList<String> encodings = new ArrayList<String>();
            final HashMap<File, InputFile> inputs = new HashMap<File, InputFile>();
            for (InputFile inputFile : inputFiles) {
                String sourceFilePath = inputFile.absolutePath();
                inputs.put(new File(sourceFilePath), inputFile);
                sourceFilePaths.add(sourceFilePath);
                encodings.add(inputFile.charset().name());
            }
            final ExecutionTimeReport executionTimeReport = new ExecutionTimeReport();
            ProgressMonitor progressMonitor = new ProgressMonitor(isCanceled, analysisProgress);
            PerformanceMeasure.Duration batchPerformance = PerformanceMeasure.start((String)"ParseAsBatch");
            try {
                this.astParser().createASTs(sourceFilePaths.toArray(new String[0]), encodings.toArray(new String[0]), new String[0], new FileASTRequestor(){

                    public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                        Result result;
                        PerformanceMeasure.Duration convertDuration = PerformanceMeasure.start((String)"Convert");
                        analyzedSourceFilePaths.add(sourceFilePath);
                        InputFile inputFile = (InputFile)inputs.get(new File(sourceFilePath));
                        executionTimeReport.start(inputFile);
                        try {
                            result = new Result(JParser.convert(javaVersion.effectiveJavaVersionAsString(), inputFile.filename(), inputFile.contents(), ast));
                        }
                        catch (Exception e) {
                            result = new Result(e);
                        }
                        convertDuration.stop();
                        PerformanceMeasure.Duration analyzeDuration = PerformanceMeasure.start((String)"Analyze");
                        action.accept(inputFile, result);
                        executionTimeReport.end();
                        analyzeDuration.stop();
                    }
                }, (IProgressMonitor)progressMonitor);
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                List<InputFile> notYetAnalyzedFiles = sourceFilePaths.stream().filter(file -> !analyzedSourceFilePaths.contains(file)).map(file -> (InputFile)inputs.get(new File((String)file))).collect(Collectors.toList());
                if (!notYetAnalyzedFiles.isEmpty()) {
                    action.accept((InputFile)notYetAnalyzedFiles.get(0), new Result(e));
                    this.fallbackToFileByFileMode(notYetAnalyzedFiles, isCanceled, action);
                } else if (!sourceFilePaths.isEmpty()) {
                    InputFile lastInputFile = (InputFile)inputs.get(new File((String)sourceFilePaths.get(sourceFilePaths.size() - 1)));
                    action.accept(lastInputFile, new Result(e));
                } else {
                    LOG.warn("Unexpected {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                }
            }
            finally {
                batchPerformance.stop();
                executionTimeReport.reportAsBatch();
                progressMonitor.done();
            }
        }

        private void fallbackToFileByFileMode(List<InputFile> inputFiles, BooleanSupplier isCanceled, BiConsumer<InputFile, Result> action) {
            LOG.warn("Fallback to file by file analysis for {} files", (Object)inputFiles.size());
            for (InputFile inputFile : inputFiles) {
                if (isCanceled.getAsBoolean()) break;
                FileByFile.parse(this.astParser(), inputFile, this.javaVersion, action);
            }
        }
    }

    public static class Result {
        private final Exception e;
        private final JavaTree.CompilationUnitTreeImpl t;

        private Result(Exception e) {
            this.e = e;
            this.t = null;
        }

        private Result(JavaTree.CompilationUnitTreeImpl t) {
            this.e = null;
            this.t = t;
        }

        public JavaTree.CompilationUnitTreeImpl get() throws Exception {
            if (this.e != null) {
                throw this.e;
            }
            return this.t;
        }
    }

    public static enum Mode {
        BATCH(Batch::new),
        FILE_BY_FILE((x$0, x$1, x$2) -> new FileByFile(x$0, x$1, x$2));

        private final ParserConfigConstructor supplier;

        private Mode(ParserConfigConstructor supplier) {
            this.supplier = supplier;
        }

        public JParserConfig create(JavaVersion javaVersion, List<File> classpath) {
            return this.create(javaVersion, classpath, false);
        }

        public JParserConfig create(JavaVersion javaVersion, List<File> classpath, boolean shouldIgnoreUnnamedModuleForSplitPackage) {
            if (shouldIgnoreUnnamedModuleForSplitPackage) {
                LOG.info("The Java analyzer will ignore the unnamed module for split packages.");
            }
            return this.supplier.apply(javaVersion, classpath, shouldIgnoreUnnamedModuleForSplitPackage);
        }
    }
}

