/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.classpath;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Configuration;
import org.sonar.java.classpath.AbstractClasspath;

public class ClasspathForTest
extends AbstractClasspath {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathForTest.class);
    private boolean hasSuspiciousEmptyLibraries = false;
    private boolean alreadyReported = false;

    public ClasspathForTest(Configuration settings, FileSystem fs) {
        super(settings, fs, InputFile.Type.TEST);
    }

    @Override
    protected void init() {
        if (!this.initialized) {
            this.validateLibraries = this.fs.hasFiles(this.fs.predicates().all());
            this.initialized = true;
            this.binaries.addAll(this.getFilesFromProperty("sonar.java.test.binaries"));
            LinkedHashSet<File> libraries = new LinkedHashSet<File>(this.getJdkJars());
            Set<File> extraLibraries = this.getFilesFromProperty("sonar.java.test.libraries");
            ClasspathForTest.logResolvedFiles("sonar.java.test.libraries", extraLibraries);
            libraries.addAll(extraLibraries);
            this.hasSuspiciousEmptyLibraries = libraries.isEmpty() && this.hasJavaSources();
            this.elements.addAll(this.binaries);
            this.elements.addAll(libraries);
        }
    }

    @Override
    public void logSuspiciousEmptyLibraries() {
        if (this.hasSuspiciousEmptyLibraries && !this.alreadyReported) {
            String warning = String.format("Dependencies/libraries were not provided for analysis of %s files. The '%s' property is empty. Verify your configuration, as you might end up with less precise results.", "TEST", "sonar.java.test.libraries");
            LOG.warn(warning);
            this.alreadyReported = true;
        }
    }
}

