/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

public class AnalysisProgress {
    private final int totalFileCount;
    private int currentBatchSize;
    private int analysedFileCount;

    public AnalysisProgress(int totalFileCount) {
        this.totalFileCount = totalFileCount;
        this.currentBatchSize = 0;
        this.analysedFileCount = 0;
    }

    public void startBatch(int currentBatchSize) {
        this.currentBatchSize = currentBatchSize;
    }

    public void endBatch() {
        this.analysedFileCount += this.currentBatchSize;
        this.currentBatchSize = 0;
    }

    public boolean isFirstBatch() {
        return this.analysedFileCount == 0;
    }

    public boolean isLastBatch() {
        return this.analysedFileCount + this.currentBatchSize == this.totalFileCount;
    }

    public double toGlobalPercentage(double currentBatchPercentage) {
        if (this.totalFileCount == 0) {
            return 0.0;
        }
        double percentageDoneInPreviousBatches = (double)this.analysedFileCount / (double)this.totalFileCount;
        double currentBatchFactor = (double)this.currentBatchSize / (double)this.totalFileCount;
        return percentageDoneInPreviousBatches + currentBatchFactor * currentBatchPercentage;
    }
}

