/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.recognizers;

import java.util.Arrays;
import java.util.List;
import org.sonarsource.analyzer.commons.recognizers.Detector;
import org.sonarsource.analyzer.commons.recognizers.StringUtils;

public class ContainsDetector
extends Detector {
    private final List<String> strs;

    public ContainsDetector(double probability, String ... strs) {
        super(probability);
        this.strs = Arrays.asList(strs);
    }

    @Override
    public int scan(String line) {
        String lineWithoutWhitespaces = line.replaceAll("\\s+", "");
        int matchers = 0;
        for (String str : this.strs) {
            matchers += StringUtils.countMatches(lineWithoutWhitespaces, str);
        }
        return matchers;
    }
}

