/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sign;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.simplify4u.plugins.sign.SignResult;
import org.simplify4u.plugins.sign.openpgp.PGPKeyInfo;
import org.simplify4u.plugins.sign.openpgp.PGPSigner;

public abstract class ArtifactSigner {
    @Inject
    protected MavenProject project;
    @Inject
    protected PGPSigner pgpSigner;

    protected Artifact mArtifactToAether(org.apache.maven.artifact.Artifact artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getArtifactHandler().getExtension(), artifact.getVersion(), null, artifact.getFile());
    }

    protected SignResult makeSignature(Artifact artifact, InputStream inputStream) {
        String artifactId = artifact.getArtifactId();
        String classifier = artifact.getClassifier();
        String version = artifact.getVersion();
        String extension = artifact.getExtension();
        String targetExt = extension + ".asc";
        String targetName = artifactId + '-' + version;
        if (classifier != null && !classifier.isEmpty()) {
            targetName = targetName + "-" + classifier;
        }
        targetName = targetName + "." + targetExt;
        Path target = Paths.get(this.project.getBuild().getDirectory(), targetName);
        this.pgpSigner.sign(inputStream, target);
        return new SignResult(classifier, targetExt, target.toFile());
    }

    public void setKeyInfo(PGPKeyInfo pgpKeyInfo) {
        this.pgpSigner.setKeyInfo(pgpKeyInfo);
    }

    public abstract List<SignResult> signArtifact(org.apache.maven.artifact.Artifact var1);
}

