/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.trace.Trace;

class SocketBufferAppender {
    private ByteBuffer buffer;
    private Trace trace;
    private int chunk;
    private int limit;

    public SocketBufferAppender(Socket socket, int chunk, int limit) {
        this.buffer = ByteBuffer.allocateDirect(chunk);
        this.trace = socket.getTrace();
        this.chunk = chunk;
        this.limit = limit;
    }

    public int space() {
        return this.buffer.remaining();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int length() {
        return this.capacity() - this.space();
    }

    public String encode() throws IOException {
        return this.encode("UTF-8");
    }

    public String encode(String encoding) throws IOException {
        ByteBuffer segment = this.buffer.duplicate();
        if (segment != null) {
            segment.flip();
        }
        return this.encode(encoding, segment);
    }

    private String encode(String encoding, ByteBuffer segment) throws IOException {
        Charset charset = Charset.forName(encoding);
        CharBuffer text = charset.decode(segment);
        return text.toString();
    }

    public int append(ByteBuffer data) throws IOException {
        int space;
        int require = data.remaining();
        if (require > (space = this.space())) {
            require = space;
        }
        return this.append(data, require);
    }

    public int append(ByteBuffer data, int count) throws IOException {
        ByteBuffer segment = data.slice();
        int mark = data.position();
        int size = mark + count;
        if (count > 0) {
            if (this.trace != null) {
                this.trace.trace((Object)TransportEvent.WRITE_BUFFER, count);
            }
            data.position(size);
            segment.limit(count);
            this.buffer.put(segment);
        }
        return count;
    }

    public int write(ByteChannel channel) throws IOException {
        int size = this.length();
        if (size <= 0) {
            return 0;
        }
        return this.write(channel, size);
    }

    public int write(ByteChannel channel, int count) throws IOException {
        if (count <= 0) {
            return 0;
        }
        this.buffer.flip();
        return this.write(channel, this.buffer);
    }

    private int write(ByteChannel channel, ByteBuffer segment) throws IOException {
        int count;
        int size;
        int require = segment.remaining();
        for (count = 0; count < require && (size = channel.write(segment)) > 0; count += size) {
            if (this.trace == null) continue;
            this.trace.trace((Object)TransportEvent.WRITE, size);
        }
        if (count >= 0) {
            segment.compact();
        }
        return count;
    }
}

