/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.opera;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;

public class OperaDriverService
extends DriverService {
    public static final String OPERA_DRIVER_EXE_PROPERTY = "webdriver.opera.driver";
    public static final String OPERA_DRIVER_LOG_PROPERTY = "webdriver.opera.logfile";
    public static final String OPERA_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.opera.verboseLogging";
    public static final String OPERA_DRIVER_SILENT_OUTPUT_PROPERTY = "webdriver.opera.silentOutput";

    public OperaDriverService(File executable, int port, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, args, environment);
    }

    public OperaDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, args, environment);
    }

    public static OperaDriverService createDefaultService() {
        return (OperaDriverService)new Builder().build();
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<OperaDriverService, Builder> {
        private boolean verbose = Boolean.getBoolean("webdriver.opera.verboseLogging");
        private boolean silent = Boolean.getBoolean("webdriver.opera.silentOutput");

        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.OPERA.is(capabilities)) {
                ++score;
            }
            if (capabilities.getCapability("operaOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder withSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        protected File findDefaultExecutable() {
            return OperaDriverService.findExecutable((String)"operadriver", (String)OperaDriverService.OPERA_DRIVER_EXE_PROPERTY, (String)"https://github.com/operasoftware/operachromiumdriver", (String)"https://github.com/operasoftware/operachromiumdriver/releases");
        }

        protected List<String> createArgs() {
            String logFilePath;
            if (this.getLogFile() == null && (logFilePath = System.getProperty(OperaDriverService.OPERA_DRIVER_LOG_PROPERTY)) != null) {
                this.withLogFile(new File(logFilePath));
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                args.add(String.format("--log-path=%s", this.getLogFile().getAbsolutePath()));
            }
            if (this.verbose) {
                args.add("--verbose");
            }
            if (this.silent) {
                args.add("--silent");
            }
            return Collections.unmodifiableList(args);
        }

        protected OperaDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new OperaDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

