/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Version
implements Cloneable {
    private static final Pattern SEMVER_PATTERN = Pattern.compile("(\\d+)(\\.(\\d+)(?:\\.)?(\\d*))?(\\.|-|\\+)?([0-9A-Za-z-.]*)?");
    private int major;
    private int minor;
    private int patch;
    private String suffixSeparator;
    private String suffix;

    static Version parse(String version) {
        Matcher m = SEMVER_PATTERN.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not update the version string '" + version + ". It does not follow semver schema.");
        }
        int major = Integer.valueOf(m.group(1));
        String minorMatch = m.group(3);
        int minor = minorMatch == null || minorMatch.isEmpty() ? 0 : Integer.valueOf(minorMatch);
        int patch = 0;
        String patchMatch = m.group(4);
        if (patchMatch != null && !patchMatch.isEmpty()) {
            patch = Integer.valueOf(patchMatch);
        }
        String sep = m.group(5);
        String suffix = m.group(6);
        if (sep != null && sep.isEmpty()) {
            sep = null;
        }
        if (suffix != null && suffix.isEmpty()) {
            suffix = null;
        }
        return new Version(major, minor, patch, sep, suffix);
    }

    public Version() {
    }

    public Version(int major, int minor, int patch, String suffixSeparator, String suffix) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.suffix = suffix;
        this.suffixSeparator = suffixSeparator;
        if (suffix != null && (suffixSeparator == null || suffixSeparator.isEmpty())) {
            this.suffixSeparator = "-";
        }
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int patch) {
        this.patch = patch;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        if (suffix != null && this.suffixSeparator == null) {
            this.suffixSeparator = "-";
        }
        this.suffix = suffix;
    }

    public String getSuffixSeparator() {
        return this.suffixSeparator;
    }

    public void setSuffixSeparator(String suffixSeparator) {
        this.suffixSeparator = suffixSeparator;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (this.suffix == null ? "" : this.suffixSeparator) + (this.suffix == null ? "" : this.suffix);
    }

    public Version clone() {
        try {
            return (Version)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("Clone not supported on a cloneable class. WFT?", e);
        }
    }
}

