/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.text.ParsePosition;
import org.python.icu.text.AbsoluteValueSubstitution;
import org.python.icu.text.DecimalFormat;
import org.python.icu.text.FractionalPartSubstitution;
import org.python.icu.text.IntegralPartSubstitution;
import org.python.icu.text.ModulusSubstitution;
import org.python.icu.text.MultiplierSubstitution;
import org.python.icu.text.NFRule;
import org.python.icu.text.NFRuleSet;
import org.python.icu.text.NullSubstitution;
import org.python.icu.text.NumeratorSubstitution;
import org.python.icu.text.RuleBasedNumberFormat;
import org.python.icu.text.SameValueSubstitution;

abstract class NFSubstitution {
    final int pos;
    final NFRuleSet ruleSet;
    final DecimalFormat numberFormat;
    final RuleBasedNumberFormat rbnf;

    public static NFSubstitution makeSubstitution(int pos, NFRule rule, NFRule rulePredecessor, NFRuleSet ruleSet, RuleBasedNumberFormat formatter2, String description) {
        if (description.length() == 0) {
            return new NullSubstitution(pos, ruleSet, formatter2, description);
        }
        switch (description.charAt(0)) {
            case '<': {
                if (rule.getBaseValue() == -1L) {
                    throw new IllegalArgumentException("<< not allowed in negative-number rule");
                }
                if (rule.getBaseValue() == -2L || rule.getBaseValue() == -3L || rule.getBaseValue() == -4L) {
                    return new IntegralPartSubstitution(pos, ruleSet, formatter2, description);
                }
                if (ruleSet.isFractionSet()) {
                    return new NumeratorSubstitution(pos, rule.getBaseValue(), formatter2.getDefaultRuleSet(), formatter2, description);
                }
                return new MultiplierSubstitution(pos, rule.getDivisor(), ruleSet, formatter2, description);
            }
            case '>': {
                if (rule.getBaseValue() == -1L) {
                    return new AbsoluteValueSubstitution(pos, ruleSet, formatter2, description);
                }
                if (rule.getBaseValue() == -2L || rule.getBaseValue() == -3L || rule.getBaseValue() == -4L) {
                    return new FractionalPartSubstitution(pos, ruleSet, formatter2, description);
                }
                if (ruleSet.isFractionSet()) {
                    throw new IllegalArgumentException(">> not allowed in fraction rule set");
                }
                return new ModulusSubstitution(pos, rule.getDivisor(), rulePredecessor, ruleSet, formatter2, description);
            }
            case '=': {
                return new SameValueSubstitution(pos, ruleSet, formatter2, description);
            }
        }
        throw new IllegalArgumentException("Illegal substitution character");
    }

    NFSubstitution(int pos, NFRuleSet ruleSet, RuleBasedNumberFormat formatter2, String description) {
        this.pos = pos;
        this.rbnf = formatter2;
        if (description.length() >= 2 && description.charAt(0) == description.charAt(description.length() - 1)) {
            description = description.substring(1, description.length() - 1);
        } else if (description.length() != 0) {
            throw new IllegalArgumentException("Illegal substitution syntax");
        }
        if (description.length() == 0) {
            this.ruleSet = ruleSet;
            this.numberFormat = null;
        } else if (description.charAt(0) == '%') {
            this.ruleSet = formatter2.findRuleSet(description);
            this.numberFormat = null;
        } else if (description.charAt(0) == '#' || description.charAt(0) == '0') {
            this.ruleSet = null;
            this.numberFormat = new DecimalFormat(description, formatter2.getDecimalFormatSymbols());
        } else if (description.charAt(0) == '>') {
            this.ruleSet = ruleSet;
            this.numberFormat = null;
        } else {
            throw new IllegalArgumentException("Illegal substitution syntax");
        }
    }

    public void setDivisor(int radix, int exponent) {
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (this.getClass() == that.getClass()) {
            NFSubstitution that2 = (NFSubstitution)that;
            return this.pos == that2.pos && (this.ruleSet != null || that2.ruleSet == null) && (this.numberFormat == null ? that2.numberFormat == null : this.numberFormat.equals(that2.numberFormat));
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        if (this.ruleSet != null) {
            return this.tokenChar() + this.ruleSet.getName() + this.tokenChar();
        }
        return this.tokenChar() + this.numberFormat.toPattern() + this.tokenChar();
    }

    public void doSubstitution(long number, StringBuffer toInsertInto, int position) {
        if (this.ruleSet != null) {
            long numberToFormat = this.transformNumber(number);
            this.ruleSet.format(numberToFormat, toInsertInto, position + this.pos);
        } else {
            double numberToFormat = this.transformNumber((double)number);
            if (this.numberFormat.getMaximumFractionDigits() == 0) {
                numberToFormat = Math.floor(numberToFormat);
            }
            toInsertInto.insert(position + this.pos, this.numberFormat.format(numberToFormat));
        }
    }

    public void doSubstitution(double number, StringBuffer toInsertInto, int position) {
        double numberToFormat = this.transformNumber(number);
        if (numberToFormat == Math.floor(numberToFormat) && this.ruleSet != null) {
            this.ruleSet.format((long)numberToFormat, toInsertInto, position + this.pos);
        } else if (this.ruleSet != null) {
            this.ruleSet.format(numberToFormat, toInsertInto, position + this.pos);
        } else {
            toInsertInto.insert(position + this.pos, this.numberFormat.format(numberToFormat));
        }
    }

    public abstract long transformNumber(long var1);

    public abstract double transformNumber(double var1);

    public Number doParse(String text2, ParsePosition parsePosition, double baseValue, double upperBound, boolean lenientParse) {
        Number tempResult;
        upperBound = this.calcUpperBound(upperBound);
        if (this.ruleSet != null) {
            tempResult = this.ruleSet.parse(text2, parsePosition, upperBound);
            if (lenientParse && !this.ruleSet.isFractionSet() && parsePosition.getIndex() == 0) {
                tempResult = this.rbnf.getDecimalFormat().parse(text2, parsePosition);
            }
        } else {
            tempResult = this.numberFormat.parse(text2, parsePosition);
        }
        if (parsePosition.getIndex() != 0) {
            double result2 = tempResult.doubleValue();
            if ((result2 = this.composeRuleValue(result2, baseValue)) == (double)((long)result2)) {
                return (long)result2;
            }
            return new Double(result2);
        }
        return tempResult;
    }

    public abstract double composeRuleValue(double var1, double var3);

    public abstract double calcUpperBound(double var1);

    public final int getPos() {
        return this.pos;
    }

    abstract char tokenChar();

    public boolean isNullSubstitution() {
        return false;
    }

    public boolean isModulusSubstitution() {
        return false;
    }
}

